/*
 * Decompiled with CFR 0.152.
 */
package com.ist.debug.reqMgr;

import com.ist.debug.EventAndRequestState;
import com.ist.debug.reqMgr.RequestManager;
import com.ist.debug.reqMgr.RequestMediator;
import com.ist.debug.support.Reply;
import com.militsa.tools.BitManipulation;
import jdwp.Misc;
import jdwp.MiscSizes;
import jdwp.Value;

public class FrameSetValues
extends RequestManager
implements Misc,
MiscSizes {
    private int threadID;
    private long frameID;

    public FrameSetValues(RequestMediator mediator) {
        super(mediator);
    }

    public void manageRequest(int requestId, int length, byte[][] buffers) {
        byte[] buf = buffers[1];
        int threadID = this.threadID = BitManipulation.getInt(buf, 0, true);
        long frameID = this.frameID = BitManipulation.getLong(buf, 4, true) & 0xFFFFFFFFL;
        int noSlots = BitManipulation.getInt(buf, 12, true);
        int error = 0;
        int off = 16;
        Value value = new Value();
        int i = 0;
        while (i < noSlots) {
            int slot = BitManipulation.getInt(buf, off, true);
            off += 4;
            off = Value.get(value, buf, off);
            error = EventAndRequestState.setValueByStackFrame(threadID, frameID, slot, value.tag, value.data);
            if (error < 0) {
                noSlots = i;
            }
            ++i;
        }
        Reply reply = new Reply(buffers, requestId);
        switch (error) {
            case -1: {
                reply.setError((short)10);
                break;
            }
            case -2: {
                reply.setError((short)30);
                break;
            }
            case -3: {
                reply.setError((short)20);
            }
        }
        reply.setOffset(off);
        reply.send();
    }

    public String toString() {
        return String.valueOf(super.toString()) + "for thread " + this.threadID + ", frame " + this.frameID;
    }
}

