/*
 * Decompiled with CFR 0.152.
 */
package com.ist.debug.reqMgr;

import com.ist.debug.EventAndRequestState;
import com.ist.debug.reqMgr.RequestManager;
import com.ist.debug.reqMgr.RequestMediator;
import com.ist.debug.support.Reply;
import com.militsa.tools.BitManipulation;
import jdwp.Misc;
import jdwp.MiscSizes;
import jdwp.Value;

public class FrameGetValuesRequestManager
extends RequestManager
implements Misc,
MiscSizes {
    public int threadID;
    public long frameID;

    public FrameGetValuesRequestManager(RequestMediator mediator) {
        super(mediator);
    }

    public void manageRequest(int requestId, int length, byte[][] buffers) {
        byte[] buf = buffers[1];
        int threadID = this.threadID = BitManipulation.getInt(buf, 0, true);
        long frameID = this.frameID = BitManipulation.getLong(buf, 4, true) & 0xFFFFFFFFL;
        int noSlots = BitManipulation.getInt(buf, 12, true);
        int error = 0;
        int off = 16;
        int[] value = new int[3];
        Value[] values = new Value[noSlots];
        int i = 0;
        while (i < noSlots) {
            int requestedSlot = BitManipulation.getInt(buf, off, true);
            byte tagByte = buf[off += 4];
            ++off;
            error = EventAndRequestState.getValueByStackFrame(threadID, frameID, requestedSlot, tagByte, false, value);
            if (error < 0) {
                noSlots = i;
                break;
            }
            values[i] = new Value((byte)value[0], (long)value[1] << 32 | (long)value[2] & 0xFFFFFFFFL);
            ++i;
        }
        Reply reply = new Reply(buffers, requestId);
        switch (error) {
            case -1: {
                reply.setError((short)10);
                break;
            }
            case -2: {
                reply.setError((short)30);
                break;
            }
            case -3: {
                reply.setError((short)20);
            }
        }
        reply.putInt(noSlots);
        int i2 = 0;
        while (i2 < noSlots) {
            values[i2].put(reply, true);
            ++i2;
        }
        reply.send();
    }

    public String toString() {
        return String.valueOf(super.toString()) + "for frame " + this.frameID + " of thread " + this.threadID;
    }
}

