/*
 * Decompiled with CFR 0.152.
 */
package com.ist.debug.reqMgr;

import com.ist.debug.DebugThread;
import com.ist.debug.reqMgr.RequestManager;
import com.ist.debug.reqMgr.RequestMediator;
import com.ist.debug.reqMgr.event.ClassExcludeEventModifier;
import com.ist.debug.reqMgr.event.ClassMatchEventModifier;
import com.ist.debug.reqMgr.event.ClassOnlyEventModifier;
import com.ist.debug.reqMgr.event.ConditionalEventModifier;
import com.ist.debug.reqMgr.event.CountEventModifier;
import com.ist.debug.reqMgr.event.EventDispatcher;
import com.ist.debug.reqMgr.event.EventModifier;
import com.ist.debug.reqMgr.event.ExceptionOnlyEventModifier;
import com.ist.debug.reqMgr.event.FieldOnlyEventModifier;
import com.ist.debug.reqMgr.event.InstanceOnlyEventModifier;
import com.ist.debug.reqMgr.event.InvalidEventRequestException;
import com.ist.debug.reqMgr.event.LocationOnlyEventModifier;
import com.ist.debug.reqMgr.event.StepEventModifier;
import com.ist.debug.reqMgr.event.ThreadOnlyEventModifier;
import com.ist.debug.support.Reply;
import com.militsa.tools.BitManipulation;

public class EventRequestSetRequestManager
extends RequestManager {
    private static final int EVENT_KIND_OFFSET = 0;
    private static final int SUSPEND_POLICY_OFFSET = 1;
    private static final int NB_MODIFIERS_OFFSET = 2;
    private static final int FIRST_MODIFIER_OFFSET = 6;
    private static final int MOD_KIND_OFFSET = 0;
    private EventModifier[] modifiers = null;
    private byte eventKind;
    private byte suspendPolicy;
    private int nbModifiers;
    private int dataLength;
    private int evReqID;

    public EventRequestSetRequestManager(RequestMediator mediator) {
        super(mediator);
    }

    public void manageRequest(int requestId, int dataLength, byte[][] buffers) {
        byte[] buf = buffers[1];
        this.eventKind = buf[0];
        this.suspendPolicy = buf[1];
        this.evReqID = EventDispatcher.eventRequest(requestId, this.eventKind, this.suspendPolicy);
        this.dataLength = dataLength;
        short errorCode = 0;
        try {
            this.parseModifiers(buf);
            EventDispatcher.finalizeEventRequest(this.evReqID);
        }
        catch (InvalidEventRequestException e) {
            errorCode = e.errorCode;
        }
        Reply reply = new Reply(buffers, requestId);
        reply.putInt(requestId);
        reply.setError(errorCode);
        reply.send();
    }

    public String modifiersString() {
        if (this.modifiers == null) {
            return "No modifiers";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.nbModifiers);
        sb.append(" modifier(s):");
        int i = 0;
        while (i < this.modifiers.length) {
            sb.append("\n\t");
            sb.append(this.modifiers[i]);
            ++i;
        }
        return sb.toString();
    }

    public void parseModifiers(byte[] dataBuf) {
        this.nbModifiers = BitManipulation.getInt(dataBuf, 2, true);
        if (this.nbModifiers == 0) {
            this.modifiers = null;
            return;
        }
        this.modifiers = new EventModifier[this.nbModifiers];
        int currentModOffset = 6;
        int numModifier = -1;
        while (++numModifier < this.nbModifiers) {
            EventModifier current = null;
            byte modKind = dataBuf[currentModOffset + 0];
            ++currentModOffset;
            String error = null;
            block1 : switch (modKind) {
                case 1: {
                    current = new CountEventModifier(this.evReqID, dataBuf, currentModOffset);
                    break;
                }
                case 2: {
                    current = new ConditionalEventModifier(this.evReqID, dataBuf, currentModOffset);
                    break;
                }
                case 3: {
                    if (this.eventKind == 9) {
                        error = "Thread Only Modifier isn't valid for CLASS_UNLOAD event";
                        break;
                    }
                    current = new ThreadOnlyEventModifier(this.evReqID, dataBuf, currentModOffset);
                    break;
                }
                case 4: {
                    switch (this.eventKind) {
                        case 6: 
                        case 7: 
                        case 9: {
                            error = "Class Only modifier isn't valid for THREAD_START, THREAD_END and CLASS_UNLOAD";
                            break block1;
                        }
                    }
                    current = new ClassOnlyEventModifier(this.evReqID, dataBuf, currentModOffset);
                    break;
                }
                case 5: {
                    switch (this.eventKind) {
                        case 6: 
                        case 7: {
                            error = "Class Match modifier isn't valid for THREAD_START, and THREAD_END";
                            break block1;
                        }
                    }
                    current = new ClassMatchEventModifier(this.evReqID, dataBuf, currentModOffset);
                    break;
                }
                case 6: {
                    switch (this.eventKind) {
                        case 6: 
                        case 7: {
                            error = "Class Exclude modifier isn't valid for THREAD_START, and THREAD_END";
                            break block1;
                        }
                    }
                    current = new ClassExcludeEventModifier(this.evReqID, dataBuf, currentModOffset);
                    break;
                }
                case 7: {
                    switch (this.eventKind) {
                        case 1: 
                        case 2: 
                        case 4: 
                        case 20: 
                        case 21: {
                            current = new LocationOnlyEventModifier(this.evReqID, dataBuf, currentModOffset);
                            break block1;
                        }
                    }
                    error = "LocationOnly modifier is only valid for BREAKPOINTS,FIELD_ACCESS/MODIFICATION, EXCEPTION(_CATCH), and SINGLE_STEP";
                    break;
                }
                case 8: {
                    switch (this.eventKind) {
                        case 4: {
                            current = new ExceptionOnlyEventModifier(this.evReqID, dataBuf, currentModOffset);
                            break block1;
                        }
                    }
                    error = "ExceptionOnly modifier is only valid for EXCEPTION(_CATCH)";
                    break;
                }
                case 9: {
                    switch (this.eventKind) {
                        case 20: 
                        case 21: {
                            current = new FieldOnlyEventModifier(this.evReqID, dataBuf, currentModOffset);
                            break block1;
                        }
                    }
                    error = "FieldOnly modifier is only valid for FIELD_ACCESS/MODIFICATION";
                    break;
                }
                case 10: {
                    if (this.eventKind == 1) {
                        current = new StepEventModifier(this.evReqID, dataBuf, currentModOffset);
                        break;
                    }
                    error = "Step modifier is only valid for SINGLE_STEP";
                    break;
                }
                case 11: {
                    switch (this.eventKind) {
                        case 6: 
                        case 7: 
                        case 8: 
                        case 9: {
                            error = "InstanceOnly modifier isn't valid for THREAD_START/END, CLASS_PREPARE/UNLOAD";
                        }
                    }
                    current = new InstanceOnlyEventModifier(this.evReqID, dataBuf, currentModOffset);
                    break;
                }
                default: {
                    error = "Unknown modifier kind";
                }
            }
            this.modifiers[numModifier] = current;
            try {
                currentModOffset = current.readModifier();
            }
            catch (NullPointerException e) {
                DebugThread.error(error, e);
            }
        }
    }

    private String eventName(int eventKind) {
        switch (eventKind) {
            case 1: {
                return "SINGLE_STEP";
            }
            case 2: {
                return "BREAKPOINT";
            }
            case 3: {
                return "FRAME_POP";
            }
            case 4: {
                return "EXCEPTION";
            }
            case 5: {
                return "USER_DEFINED";
            }
            case 6: {
                return "THREAD_START";
            }
            case 7: {
                return "THREAD_END/THREAD_DEATH";
            }
            case 8: {
                return "CLASS_PREPARE";
            }
            case 9: {
                return "CLASS_UNLOAD";
            }
            case 10: {
                return "CLASS_LOAD";
            }
            case 20: {
                return "FIELD_ACCESS";
            }
            case 21: {
                return "FIELD_MODIFICATION";
            }
            case 40: {
                return "METHOD_ENTRY";
            }
            case 41: {
                return "METHOD_EXIT";
            }
            case 90: {
                return "VM_INIT/VM_START";
            }
            case 99: {
                return "VM_DEATH";
            }
            case 100: {
                return "VM_DISCONNECTED";
            }
        }
        return "unknown";
    }

    public String toString() {
        return "Event request [eventKind=" + this.eventName(this.eventKind) + "(" + this.eventKind + "), suspendPolicy=" + this.suspendPolicy + ", nbModifiers=" + this.nbModifiers + "] (datalength=" + this.dataLength + ")\n" + this.modifiersString();
    }
}

