/*
 * Decompiled with CFR 0.152.
 */
package com.ist.debug.reqMgr;

import com.ist.debug.EventAndRequestState;
import com.ist.debug.reqMgr.InvokeMethodRequestManager;
import com.ist.debug.reqMgr.RequestMediator;
import com.militsa.tools.BitManipulation;

public class ClassInvokeMethodRequestManager
extends InvokeMethodRequestManager {
    private static final int classIDOffset = 0;
    private static final int threadIDOffset = 4;
    private static final int methodIDOffset = 12;
    private static final int noArgumentsOffset = 16;
    private static final int argumentsOffset = 20;

    public int getObjectID(byte[] buf) {
        return 0;
    }

    public int getThreadID(byte[] buf) {
        return BitManipulation.getInt(buf, 4, true);
    }

    public int getClassID(byte[] buf) {
        return BitManipulation.getInt(buf, 0, true) - 1;
    }

    public int getMethodID(byte[] buf) {
        return BitManipulation.getInt(buf, 12, true);
    }

    public int getNbArguments(byte[] buf) {
        return BitManipulation.getInt(buf, 16, true);
    }

    public int getArgumentsOffset() {
        return 20;
    }

    public ClassInvokeMethodRequestManager(RequestMediator mediator) {
        super(mediator);
    }

    public String toString() {
        byte[] buf = EventAndRequestState.getMethodSignature(this.classID, this.methodID);
        String sign = new String(buf, 0, buf.length);
        buf = EventAndRequestState.getMethodName(this.classID, this.methodID);
        String name = new String(buf, 0, buf.length);
        buf = EventAndRequestState.getTypeSignatureByTypeID(this.classID);
        String typeName = new String(buf, 1, buf.length - 2);
        return String.valueOf(super.toString()) + typeName + "." + name + sign;
    }
}

