/*
 * Decompiled with CFR 0.152.
 */
package com.ist.debug.reqMgr;

import com.ist.debug.EventAndRequestProductionTools;
import com.ist.debug.EventAndRequestState;
import com.ist.debug.reqMgr.RequestManager;
import com.ist.debug.reqMgr.RequestMediator;
import com.ist.debug.support.Reply;

public class ClassBySignatureRequestManager
extends RequestManager {
    private String signature = "";
    private int[] ids;

    public ClassBySignatureRequestManager(RequestMediator mediator) {
        super(mediator);
    }

    public void manageRequest(int requestId, int length, byte[][] buffers) {
        byte[] buf = buffers[1];
        String signature = EventAndRequestProductionTools.readString(buf, 0);
        String name = signature.charAt(0) == '[' ? signature : signature.substring(1, signature.length() - 1);
        this.signature = signature;
        this.ids = EventAndRequestState.getTypeIDFromName(name.toCharArray());
        if (this.ids == null) {
            System.out.println("OutOfMemoryError in JDWP request: grow Java Heap size ");
            return;
        }
        Reply reply = new Reply(buffers, requestId);
        int size = this.ids.length;
        reply.putInt(size);
        int i = 0;
        while (i < size) {
            int id = this.ids[i];
            reply.putByte(EventAndRequestState.getTypeTag(id));
            reply.putInt(id + 1);
            reply.putInt(EventAndRequestState.getInitializationStatus(id));
            ++i;
        }
        reply.send();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append("for class ").append(this.signature);
        if (this.ids != null) {
            sb.append(this.ids.length).append(" typeRefIds [");
            int i = 0;
            while (i < this.ids.length) {
                sb.append(this.ids[i]).append(' ');
                ++i;
            }
            sb.append(']');
        }
        return sb.toString();
    }
}

