/*
 * Decompiled with CFR 0.152.
 */
package com.ist.debug.reqMgr;

import com.ist.debug.EventAndRequestState;
import com.ist.debug.reqMgr.RequestManager;
import com.ist.debug.reqMgr.RequestMediator;
import com.ist.debug.support.Reply;
import com.militsa.tools.BitManipulation;
import jdwp.Misc;
import jdwp.MiscSizes;

public class ArraySetValues
extends RequestManager
implements Misc,
MiscSizes {
    public int arrayID;
    public int fromIndex;
    public int length;
    public long[] values;

    public ArraySetValues(RequestMediator mediator) {
        super(mediator);
    }

    public void manageRequest(int requestId, int length, byte[][] buffers) {
        byte[] buf = buffers[1];
        int off = 0;
        int arrayID = this.arrayID = BitManipulation.getInt(buf, off, true);
        int fromIndex = this.fromIndex = BitManipulation.getInt(buf, off += 4, true);
        int noValues = this.length = BitManipulation.getInt(buf, off += 4, true);
        off += 4;
        this.values = new long[noValues];
        int unit = (length - 4 - 4 - 4) / noValues;
        int i = 0;
        while (i < noValues) {
            long value = 0L;
            switch (unit) {
                case 1: {
                    value = buf[off++];
                    break;
                }
                case 2: {
                    value = BitManipulation.getShort(buf, off, true);
                    off += 2;
                    break;
                }
                case 4: {
                    value = BitManipulation.getInt(buf, off, true);
                    off += 4;
                    break;
                }
                case 8: {
                    value = BitManipulation.getLong(buf, off, true);
                    off += 8;
                }
            }
            this.values[i] = value;
            EventAndRequestState.setArrayValue(arrayID, i + fromIndex, value);
            ++i;
        }
        Reply reply = new Reply(buffers, requestId);
        reply.send();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(super.toString());
        sb.append(this.arrayID).append("[").append(this.fromIndex).append("..").append(this.fromIndex + this.length - 1).append("]");
        sb.append(" values: [");
        int i = 0;
        while (i < this.values.length - 1) {
            sb.append(this.values[i]).append(',');
            ++i;
        }
        if (this.values.length > 0) {
            sb.append(this.values[this.values.length - 1]);
        }
        sb.append(']');
        return sb.toString();
    }
}

