/*
 * Decompiled with CFR 0.152.
 */
package com.ist.debug.reqMgr;

import com.ist.debug.EventAndRequestState;
import com.ist.debug.reqMgr.RequestManager;
import com.ist.debug.reqMgr.RequestMediator;
import com.ist.debug.support.Reply;
import com.militsa.tools.BitManipulation;

public class ArrayLengthRequestManager
extends RequestManager {
    private int arrayID;

    public ArrayLengthRequestManager(RequestMediator mediator) {
        super(mediator);
    }

    public void manageRequest(int requestId, int length, byte[][] buffers) {
        byte[] buf = buffers[1];
        int arrayID = BitManipulation.getInt(buf, 0, true);
        int arrayLength = EventAndRequestState.getArrayLength(arrayID);
        Reply reply = new Reply(buffers, requestId);
        switch (arrayLength) {
            case -1: {
                reply.setError((short)20);
                break;
            }
            case -2: {
                reply.setError((short)508);
            }
        }
        reply.putInt(arrayLength);
        this.arrayID = arrayID;
        reply.send();
    }

    public String toString() {
        return String.valueOf(super.toString()) + " for arrayID " + this.arrayID;
    }
}

