/*
 * Decompiled with CFR 0.152.
 */
package com.ist.debug.reqMgr;

import com.ist.debug.EventAndRequestState;
import com.ist.debug.reqMgr.RequestManager;
import com.ist.debug.reqMgr.RequestMediator;
import com.ist.debug.support.Reply;
import com.militsa.tools.BitManipulation;
import jdwp.Misc;
import jdwp.MiscSizes;
import jdwp.Value;

public class ArrayGetValuesRequestManager
extends RequestManager
implements Misc,
MiscSizes {
    public int arrayID;

    public ArrayGetValuesRequestManager(RequestMediator mediator) {
        super(mediator);
    }

    public void manageRequest(int requestId, int length, byte[][] buffers) {
        byte[] buf = buffers[1];
        int arrayID = BitManipulation.getInt(buf, 0, true);
        int firstIndex = BitManipulation.getInt(buf, 4, true);
        length = BitManipulation.getInt(buf, 8, true);
        int[] values = new int[2 + length * 3];
        int resLength = EventAndRequestState.getArrayValues(arrayID, firstIndex, length, values);
        Reply reply = new Reply(buffers, requestId);
        switch (resLength) {
            case -1: {
                reply.setError((short)504);
                break;
            }
            case -2: {
                reply.setError((short)20);
                break;
            }
            case -3: {
                reply.setError((short)508);
            }
        }
        byte tagByte = (byte)values[0];
        reply.putByte(tagByte);
        reply.putInt(values[1]);
        Value val = new Value();
        switch (tagByte) {
            case 66: 
            case 67: 
            case 68: 
            case 70: 
            case 73: 
            case 74: 
            case 83: 
            case 90: {
                int i = 2;
                while (i < resLength - 1) {
                    long data = (long)values[i] << 32 | (long)values[i + 1] & 0xFFFFFFFFL;
                    val.init(tagByte, data);
                    val.put(reply, false);
                    i += 2;
                }
                break;
            }
            default: {
                int i = 2;
                while (i < resLength - 2) {
                    tagByte = (byte)values[i];
                    long data = (long)values[i + 1] << 32 | (long)values[i + 2] & 0xFFFFFFFFL;
                    val.init(tagByte, data);
                    val.put(reply, true);
                    i += 3;
                }
                break block5;
            }
        }
        this.arrayID = arrayID;
        reply.send();
    }

    public String toString() {
        return String.valueOf(super.toString()) + " for arrayID " + this.arrayID;
    }
}

