/*
 * Decompiled with CFR 0.152.
 */
package com.ist.debug.reqMgr;

import com.ist.debug.EventAndRequestState;
import com.ist.debug.reqMgr.RequestManager;
import com.ist.debug.reqMgr.RequestMediator;
import com.ist.debug.support.Reply;

public class AllThreadsRequestManager
extends RequestManager {
    private int[] thrIDs;

    public AllThreadsRequestManager(RequestMediator mediator) {
        super(mediator);
    }

    public void manageRequest(int requestId, int length, byte[][] buffers) {
        this.thrIDs = EventAndRequestState.allThreadsIds();
        int nbThreads = this.thrIDs.length;
        Reply reply = new Reply(buffers, requestId);
        reply.putInt(nbThreads);
        int i = -1;
        while (++i < nbThreads) {
            reply.putInt(this.thrIDs[i]);
        }
        reply.send();
    }

    public String toString() {
        String str = super.toString();
        StringBuffer sb = new StringBuffer(str);
        int i = this.thrIDs.length;
        while (--i >= 0) {
            try {
                byte[] buffer;
                int length;
                int threadNameId = EventAndRequestState.getThreadNameID(this.thrIDs[i]);
                String threadName = threadNameId == -1 ? "invalid" : (threadNameId == 0 ? "anonymous" : ((length = EventAndRequestState.getStringLength(threadNameId)) < 0 ? "invalid" : (!EventAndRequestState.getStringChars(threadNameId, buffer = new byte[length], 0) ? "invalid" : new String(buffer))));
                sb.append("\n\t-> ").append(threadName).append('@').append(this.thrIDs[i]);
            }
            catch (Throwable t) {
                t.printStackTrace();
                System.exit(-1);
            }
        }
        return sb.toString();
    }
}

