/*
 * Decompiled with CFR 0.152.
 */
package com.ist.debug.reqMgr;

import com.ist.debug.DebugThread;
import com.ist.debug.EventAndRequestState;
import com.ist.debug.reqMgr.RequestManager;
import com.ist.debug.reqMgr.RequestMediator;
import com.ist.debug.support.Reply;

public class AllClassesRequestManager
extends RequestManager {
    private StringBuilder sb;

    public AllClassesRequestManager(RequestMediator mediator) {
        super(mediator);
    }

    public void manageRequest(int requestId, int length, byte[][] buffers) {
        int[] classIDs = EventAndRequestState.allClassesIds();
        int nbClasses = classIDs.length;
        Reply reply = new Reply(buffers, requestId);
        if (DebugThread.VERBOSE) {
            this.sb = new StringBuilder();
            this.sb.append('(');
            this.sb.append(classIDs.length);
            this.sb.append(") ");
        }
        reply.putInt(nbClasses);
        int i = 0;
        while (i < nbClasses) {
            int classID = classIDs[i];
            reply.putByte(EventAndRequestState.getTypeTag(classID));
            reply.putInt(classID + 1);
            byte[] sBuf = EventAndRequestState.getTypeSignatureByTypeID(classID);
            reply.putBytes(sBuf);
            int status = EventAndRequestState.getInitializationStatus(classID);
            reply.putInt(status);
            if (this.sb != null) {
                this.sb.append(' ');
                this.sb.append(classID);
                this.sb.append("->");
                this.sb.append(sBuf);
            }
            ++i;
        }
        reply.send();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append(this.mediator.cmdSet).append('.').append(this.mediator.cmd).append(')');
        if (this.sb != null) {
            sb.append("\n\t");
            sb.append(this.sb.toString());
        }
        return sb.toString();
    }
}

