/*
 * Decompiled with CFR 0.152.
 */
package com.ist.debug;

import com.ist.debug.DebugServerConnectionImpl;
import com.ist.debug.DebugState;
import com.ist.debug.DebugThread;
import com.ist.debug.EventAndRequestState;
import com.ist.debug.support.Tools;
import ej.ecom.io.ServerSocketConnection;
import ej.ecom.io.SocketConnection;
import java.io.IOException;

public class InitConnectionState
extends DebugState {
    private static final byte[] HANDSHAKE_BYTES = "JDWP-Handshake".getBytes();
    private ServerSocketConnection ssocket;
    private SocketConnection socket;
    private int nbTry = 100;

    public InitConnectionState(DebugThread thread) {
        super(thread);
    }

    public void execute() {
        if (--this.nbTry < 0) {
            DebugThread.error("Impossible to connect to the debugger", null);
            this.nbTry = 100;
        }
        try {
            this.closeSockets();
            DebugThread.debug("Starting connection initialization");
            this.ssocket = new DebugServerConnectionImpl(this.dt.bindAddress, this.dt.bindPort);
            DebugThread.info("Listening for transport dt_socket at address: " + this.dt.bindPort);
            this.socket = (SocketConnection)this.ssocket.acceptAndOpen();
            this.dt.setStreams(this.socket.openOutputStream(), this.socket.openInputStream());
            if (this.doHandShake()) {
                DebugThread.debug("Connection initialization OK");
                DebugThread.handshakeDone();
                this.nextState();
            } else {
                this.closeSockets();
            }
        }
        catch (IOException e) {
            DebugThread.error("Error during server connection initialization", e);
            DebugThread.INSTANCE.isDebugging = false;
            this.closeSockets();
        }
    }

    private void closeSockets() {
        Tools.closeSilently(this.socket);
        Tools.closeSilently(this.ssocket);
    }

    public void nextState() {
        this.dt.state = new EventAndRequestState(this.dt, this);
    }

    private boolean doHandShake() {
        block3: {
            int length = HANDSHAKE_BYTES.length;
            byte[] recB = new byte[length];
            this.dt.readAll(recB, length);
            if (!Tools.arrayCompare(recB, 0, HANDSHAKE_BYTES, 0, length)) break block3;
            DebugThread.debug("HandShake successful");
            this.dt.outputStream.write(HANDSHAKE_BYTES);
            return true;
        }
        try {
            DebugThread.error("Error during handshake : bad request from client", null);
        }
        catch (IOException e) {
            DebugThread.error("Error during handshake : IOException occurred", e);
        }
        return false;
    }
}

