/*
 * Decompiled with CFR 0.152.
 */
package com.ist.debug;

import com.ist.debug.DebugState;
import com.ist.debug.DebugThread;
import com.ist.debug.EventAndRequestProductionTools;
import com.ist.debug.InitConnectionState;
import com.ist.debug.NormalTerminationException;
import com.ist.debug.reqMgr.RequestMediator;
import com.ist.debug.reqMgr.event.EventDispatcher;
import com.militsa.tools.BitManipulation;
import java.io.IOException;
import java.io.InputStream;

public class EventAndRequestState
extends DebugState {
    private static final int MAX_REQUEST = 10;
    public static final int HEADER_BUFFER_IDX = 0;
    public static final int DATA_BUFFER_IDX = 1;
    public static final int REQUEST_DATA_MAX_SIZE = 65536;
    public byte[] reqHeaderBuf = new byte[11];
    EventDispatcher dispatcher;
    public byte[] reqDataBuf = new byte[65536];
    public byte[][] reqBufs = new byte[][]{this.reqHeaderBuf, this.reqDataBuf};
    public RequestMediator reqMediator = new RequestMediator(this.reqBufs);
    public DebugState connectState;

    public EventAndRequestState(DebugThread thread, InitConnectionState connectState) {
        super(thread);
        this.dispatcher = new EventDispatcher(this);
        EventAndRequestState.holdEvents(false);
        this.connectState = connectState;
    }

    public static native byte getSuspendPolicy();

    public static native int[] allThreadsIds();

    public static native int[] allClassesIds();

    public static native String getBootClasspath();

    public static native String getClasspath();

    public static native int[] getTypeIDFromName(char[] var0);

    public static native int getTypeIDFromClassObject(int var0);

    public static native byte[] getTypeSignatureByTypeID(int var0);

    public static native int getClassObjectByTypeID(int var0);

    public static native int getClassLoaderByTypeID(int var0);

    public static native byte getTypeTag(int var0);

    public static native int getTypeModBits(int var0);

    public static native int getType(int var0);

    public static native int getArrayLength(int var0);

    public static native int getArrayValues(int var0, int var1, int var2, int[] var3);

    public static native int setArrayValue(int var0, int var1, long var2);

    public static native int getInitializationStatus(int var0);

    public static native void holdEvents(boolean var0);

    public static native int getThreadStatus(int var0);

    public static native int getThreadNameID(int var0);

    public static native int getThreadPriority(int var0);

    public static native int getSuspendCount(int var0);

    public static native int getNbStackFrames(int var0);

    public static native int getValueByStackFrame(int var0, long var1, int var3, int var4, boolean var5, int[] var6);

    public static native int setValueByStackFrame(int var0, long var1, int var3, byte var4, long var5);

    public static native int getFrames(int var0, long[] var1, int var2, int var3);

    public static native int popFrames(int var0, long var1);

    public static native int getNbMethodsLocally(int var0);

    public static native byte[] getMethodName(int var0, int var1);

    public static native byte[] getMethodSignature(int var0, int var1);

    public static native int invokeMethod(int var0, int var1, int var2, int var3, byte[] var4, long[] var5);

    public static native int disableCollection(int var0);

    public static native int enableCollection(int var0);

    public static native long[] variableTable(int var0, int var1);

    public static native String getInternalName(int var0);

    public static native int createString(byte[] var0, int var1, int var2);

    public static native int getStringLength(int var0);

    public static native boolean getStringChars(int var0, byte[] var1, int var2);

    public static native int getID(Object var0);

    public static native boolean isValidObjectID(int var0);

    public static native void disposeObject(int var0);

    public static native int getMethodModBits(int var0, int var1);

    public static native int[] getSlotsAndArgsInfosByMethod(int var0, int var1);

    public static native int getNbFieldsLocally(int var0);

    public static native byte[] getFieldName(int var0, int var1);

    public static native byte[] getFieldSignature(int var0, int var1);

    public static native int getFieldModBits(int var0, int var1);

    public static native int getFieldValue(int var0, int var1, int var2, int[] var3);

    public static native int setFieldValue(int var0, int var1, int var2, long var3);

    public static native void suspendVM();

    public static native int suspendThread(int var0);

    public static native void resumeVM(int var0);

    public static native int resumeThread(int var0, int var1);

    public static native int nbLines(int var0, int var1);

    public static native int lineTable(int var0, int var1, long[] var2);

    public static native int sourceFile(int var0);

    public static native int[] getInterfacesLocally(int var0);

    public static native int getSuperClass(int var0);

    public static native int throwException(int var0, int var1);

    public static native int newArray(int var0, int var1);

    public boolean manageRequest() throws IOException {
        InputStream is = this.dt.inputStream;
        if (is.available() < 11) {
            return false;
        }
        try {
            this.dt.readAll(this.reqHeaderBuf, 11);
            int length = BitManipulation.getInt(this.reqHeaderBuf, 0, true);
            int reqID = BitManipulation.getInt(this.reqHeaderBuf, 4, true);
            boolean isReply = (this.reqHeaderBuf[8] & 0x80) != 0;
            short errorCode = 0;
            byte cmdSet = 0;
            byte cmd = 0;
            if (isReply) {
                errorCode = BitManipulation.getShort(this.reqHeaderBuf, 9, true);
            } else {
                cmdSet = this.reqHeaderBuf[9];
                cmd = this.reqHeaderBuf[10];
            }
            this.dt.readAll(this.reqDataBuf, length -= 11);
            if (DebugThread.VERBOSE) {
                DebugThread.debug(isReply ? "REPLY" : "REQUEST");
                EventAndRequestProductionTools.debugBuffer("HEADER", this.reqHeaderBuf, 11);
                EventAndRequestProductionTools.debugBuffer("DATA", this.reqDataBuf, length);
            }
            if (isReply) {
                this.reqMediator.dispatchReply(length, reqID, errorCode);
            } else {
                this.reqMediator.dispatchRequest(length, reqID, cmdSet, cmd);
            }
            return true;
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            return false;
        }
    }

    public void execute() {
        int remaining = 10;
        try {
            while (--remaining >= 0 && this.manageRequest()) {
                DebugThread.debug("REQUEST -- remaining=" + remaining);
            }
        }
        catch (IOException e) {
            DebugThread.error("Error during reception of request", e);
        }
        this.dispatcher.produceEvents();
        if (Thread.activeCount() == 0) {
            throw new NormalTerminationException();
        }
    }

    public void nextState() {
        this.dt.state = this.connectState;
    }
}

