/*
 * Decompiled with CFR 0.152.
 */
package com.ist.debug;

import com.ist.debug.DebugState;
import com.ist.debug.DebugThreadException;
import com.ist.debug.InitConnectionState;
import com.ist.debug.NormalTerminationException;
import com.ist.debug.support.Tools;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class DebugThread
extends Thread {
    public static final int PERIOD = 1;
    public static boolean VERBOSE;
    public static final DebugThread INSTANCE;
    public static final int DEBUG_THREAD_FLAGS = 1;
    public static final int MAIN_DEBUG_THREAD_FLAGS = 3;
    public boolean isDebugging = true;
    public InputStream inputStream;
    public OutputStream outputStream;
    public int bindPort;
    public int bindAddress;
    public DebugState state;

    static {
        INSTANCE = new DebugThread();
        DebugThread.setDebugThread(INSTANCE, 3);
        INSTANCE.start();
    }

    public static native void setDebugThread(Thread var0, int var1);

    public static native String getApplicationProperty(String var0);

    public static final void info(String message) {
        System.out.println(message);
    }

    public static final void debug(String message) {
        if (VERBOSE) {
            System.out.println("[DEBUG " + Thread.currentThread().getName() + "] " + message);
        }
    }

    public static final void error(String message, Exception e) {
        if (VERBOSE) {
            System.err.println("[ERROR] " + message);
        }
        if (e != null) {
            e.printStackTrace();
        }
        throw new DebugThreadException(message);
    }

    public static native int getBindPort();

    public static native int getBindAddress();

    public static native int createServerSocket(int var0, int var1);

    public static native void handshakeDone();

    private DebugThread() {
        super("debugThread");
        this.systemThread = true;
        this.priority = 10;
        this.state = new InitConnectionState(this);
        this.bindPort = DebugThread.getBindPort();
        this.bindAddress = DebugThread.getBindAddress();
    }

    public void setStreams(OutputStream out, InputStream in) throws IOException {
        Tools.closeSilently(this.outputStream);
        Tools.closeSilently(this.inputStream);
        this.outputStream = out;
        this.inputStream = in;
    }

    public void run() {
        this.setVerboseMode();
        int errorCode = 0;
        DebugThread.debug("Debug Thread started");
        try {
            while (this.isDebugging) {
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException interruptedException) {}
                this.state.execute();
            }
        }
        catch (NormalTerminationException normalTerminationException) {
            DebugThread.debug("NormalTerminationException");
        }
        catch (DebugThreadException debugThreadException) {
            DebugThread.debug("DebugThreadException");
            errorCode = -1980;
        }
        DebugThread.debug("Debug Thread finished");
        DebugThread.debug("Closing pending socket streams");
        Tools.closeSilently(this.outputStream);
        Tools.closeSilently(this.inputStream);
        DebugThread.debug("Exiting");
        System.exit(errorCode);
    }

    private void setVerboseMode() {
        String verbose = DebugThread.getApplicationProperty("DEBUG.DEBUG");
        VERBOSE = "1".equals(verbose) ? true : ("2".equals(verbose) ? true : "true".equals(verbose));
    }

    public final void readAll(byte[] b, int size) {
        try {
            int nbRead = 0;
            int offset = 0;
            while (offset < size) {
                nbRead = this.inputStream.read(b, offset, size - offset);
                if (nbRead == -1 || nbRead == 0) {
                    throw new DebugThreadException("Insufficient data in stream");
                }
                offset += nbRead;
            }
        }
        catch (IOException e) {
            throw new DebugThreadException(e.getMessage());
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new DebugThreadException(e.getMessage());
        }
    }
}

