/*
 * Decompiled with CFR 0.152.
 */
package com.is2t.s3.io;

import com.is2t.s3.io.FileInputStream;
import com.is2t.s3.io.FileOutputStream;
import com.is2t.s3.io.ISTConnection;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.microedition.io.StreamConnection;

public class UnixFileConnection
extends ISTConnection
implements StreamConnection {
    private InputStream in;
    private OutputStream out;
    private String filename;

    public UnixFileConnection() {
    }

    public UnixFileConnection(String fileURL, int mode, boolean exceptionOnTimeout) {
        this.init(fileURL, mode, exceptionOnTimeout);
    }

    public void init(String fileURL, int mode, boolean exceptionOnTimeout) {
        this.filename = fileURL.substring(5);
    }

    public InputStream openInputStream() throws IOException {
        if (this.in != null) {
            throw new IOException("Stream closed or already open: " + this.filename);
        }
        this.in = new FileInputStream(this.filename);
        return this.in;
    }

    public OutputStream openOutputStream() throws IOException {
        if (this.out != null) {
            throw new IOException("Stream closed or already open: " + this.filename);
        }
        this.out = new FileOutputStream(this.filename);
        return this.out;
    }

    public DataOutputStream openDataOutputStream() throws IOException {
        return new DataOutputStream(this.openOutputStream());
    }

    public DataInputStream openDataInputStream() throws IOException {
        return new DataInputStream(this.openInputStream());
    }

    public void close() throws IOException {
        if (this.in != null) {
            this.in.close();
            this.in = null;
        } else if (this.out != null) {
            this.out.close();
            this.out = null;
        }
    }
}

