/*
 * Decompiled with CFR 0.152.
 */
package com.is2t.s3.io;

import com.is2t.s3.io.File;
import com.is2t.s3.io.FileDescriptor;
import com.is2t.s3.io.FileNotFoundException;
import com.is2t.tools.ArrayTools;
import java.io.IOException;
import java.io.OutputStream;

public class FileOutputStream
extends OutputStream {
    private FileDescriptor fd;

    public FileOutputStream(String filename) throws IOException {
        this(new File(filename), false);
    }

    public FileOutputStream(File file) throws IOException {
        this(file, false);
    }

    public FileOutputStream(String file, boolean append) throws FileNotFoundException {
        this(new File(file), append);
    }

    public FileOutputStream(File file, boolean append) throws FileNotFoundException {
        if (file.isDirectory()) {
            throw new FileNotFoundException(file.getPath());
        }
        if (!append) {
            try {
                if (!file.createNewFile()) {
                    throw new FileNotFoundException(file.getParent());
                }
            }
            catch (IOException iOException) {
                throw new FileNotFoundException(file.getParent());
            }
        }
        this.fd = new FileDescriptor();
        if (this.openNative(file.absolute(), append) != 0) {
            throw new FileNotFoundException(file.getPath());
        }
    }

    public FileOutputStream(FileDescriptor fd) {
        this.fd = fd;
        if (this.fd == null) {
            throw new NullPointerException();
        }
    }

    private native int openNative(byte[] var1, boolean var2);

    public native void close() throws IOException;

    private native void writeByteNative(int var1, int var2);

    public void write(int b) throws IOException {
        if (!this.fd.valid()) {
            throw new IOException();
        }
        this.writeByteNative(b, this.fd.descriptor);
    }

    private native int writeNative(byte[] var1, int var2, int var3, int var4);

    public void write(byte[] buf, int off, int len) throws IOException {
        ArrayTools.checkBounds((byte[])buf, (int)off, (int)len);
        if (!this.fd.valid()) {
            throw new IOException();
        }
        this.writeNative(buf, off, len, this.fd.descriptor);
    }
}

