/*
 * Decompiled with CFR 0.152.
 */
package com.is2t.s3.io;

import com.is2t.s3.io.FileFilter;
import com.is2t.s3.io.FilenameFilter;
import java.io.IOException;

public class File {
    private String path;
    private byte[] absolute;
    public static final char separatorChar;
    public static final String separator;
    public static final char pathSeparatorChar;
    public static final String pathSeparator;
    private static final int IsFile = 0;
    private static final int IsDirectory = 1;
    private static final int IsHidden = 2;
    private static final int IsReadOnly = 3;
    private static final int IsWriteOnly = 4;
    private static int index;

    static {
        separator = System.getProperty("file.separator");
        pathSeparator = System.getProperty("path.separator");
        separatorChar = separator.charAt(0);
        pathSeparatorChar = pathSeparator.charAt(0);
    }

    public File(String directory, String simpleName) {
        if (simpleName == null) {
            throw new NullPointerException();
        }
        this.path = directory == null || directory.length() == 0 ? this.normalize(simpleName) : this.normalize(String.valueOf(directory) + separatorChar + simpleName);
    }

    public File(File parent, String simpleName) {
        this(parent == null ? "" : parent.getPath(), simpleName);
    }

    public File(String filename) {
        this("", filename);
    }

    public boolean canRead() {
        return this.exists() && this.testNative(this.absolute(), 3);
    }

    public boolean canWrite() {
        return this.exists() && this.testNative(this.absolute(), 4);
    }

    public int compareTo(File file) {
        if (separatorChar == '\\') {
            return this.getPath().toUpperCase().compareTo(file.getPath().toUpperCase());
        }
        return this.getPath().compareTo(file.getPath());
    }

    public int compareTo(Object o) {
        return this.compareTo((File)o);
    }

    private native int touchNative(byte[] var1);

    public boolean createNewFile() throws IOException {
        int touch = this.touchNative(this.absolute());
        switch (touch) {
            case 0: {
                return true;
            }
            case 1: {
                return false;
            }
            case 2: {
                throw new IOException("The file is a directory.");
            }
        }
        throw new IOException("Creation failure");
    }

    private native boolean deleteDirNative(byte[] var1);

    private native boolean deleteFileNative(byte[] var1);

    public boolean delete() {
        if (this.isDirectory()) {
            return this.deleteDirNative(this.absolute());
        }
        return this.deleteFileNative(this.absolute());
    }

    public boolean equals(Object o) {
        if (o instanceof File) {
            return this.compareTo((File)o) == 0;
        }
        return false;
    }

    private native boolean existsNative(byte[] var1);

    public boolean exists() {
        return this.existsNative(this.absolute());
    }

    public File getAbsoluteFile() {
        return new File(this.getAbsolutePath());
    }

    public String getAbsolutePath() {
        return new String(this.absolute(), 0, this.absolute.length);
    }

    public File getCanonicalFile() {
        return new File(this.getCanonicalPath());
    }

    private native byte[] getCanonicalNative(byte[] var1);

    public String getCanonicalPath() {
        byte[] canon = this.getCanonicalNative(this.absolute());
        return new String(canon, 0, canon.length);
    }

    public String getName() {
        int index = this.path.lastIndexOf(separatorChar);
        if (index < 0) {
            return this.path;
        }
        return this.path.substring(index + 1, this.path.length());
    }

    public String getParent() {
        int length = this.path.length();
        int index = this.path.lastIndexOf(separatorChar);
        if (index < 0) {
            return null;
        }
        if (index == length - 1) {
            return null;
        }
        if (index == 0) {
            return this.path.substring(0, index + 1);
        }
        if (separatorChar == '\\' && length > 2 && this.path.charAt(1) == ':' && index == 2) {
            return this.path.substring(0, index + 1);
        }
        return this.path.substring(0, index);
    }

    public File getParentFile() {
        String p = this.getParent();
        if (p == null) {
            return null;
        }
        return new File(p);
    }

    public String getPath() {
        return this.path;
    }

    public int hashCode() {
        if (separatorChar == '\\') {
            return this.path.toLowerCase().hashCode() ^ 0x12D591;
        }
        return this.path.hashCode() ^ 0x12D591;
    }

    public boolean isAbsolute() {
        int length = this.path.length();
        if (length == 0) {
            return false;
        }
        int index = 0;
        if (separatorChar == '\\' && length > 2 && this.path.charAt(1) == ':') {
            index = 2;
        }
        return this.path.charAt(index) == separatorChar;
    }

    private native boolean testNative(byte[] var1, int var2);

    public boolean isDirectory() {
        return this.testNative(this.absolute(), 1);
    }

    public boolean isFile() {
        return this.testNative(this.absolute(), 0);
    }

    public boolean isHidden() {
        return this.testNative(this.absolute(), 2);
    }

    private native long lastModifiedNative(byte[] var1);

    public long lastModified() {
        return this.lastModifiedNative(this.absolute());
    }

    private native long lengthNative(byte[] var1);

    public long length() {
        if (!this.exists()) {
            return 0L;
        }
        return this.lengthNative(this.absolute());
    }

    private native byte[][] listNative(byte[] var1);

    public String[] list() {
        if (!this.isDirectory()) {
            return null;
        }
        byte[][] list = this.listNative(this.absolute());
        if (list == null) {
            return new String[0];
        }
        String[] filenames = new String[list.length];
        int i = list.length;
        while (--i >= 0) {
            int listLength = list[i].length;
            int ptrList = -1;
            while (++ptrList < listLength && list[i][ptrList] != 0) {
            }
            filenames[i] = new String(list[i], 0, ptrList);
        }
        return filenames;
    }

    public File[] listFiles() {
        String[] filenames = this.list();
        if (filenames == null) {
            return null;
        }
        int length = filenames.length;
        File[] files = new File[length];
        int i = length;
        while (--i >= 0) {
            files[i] = new File(this, filenames[i]);
        }
        return files;
    }

    public static native char[] listRootsNative();

    public static File[] listRoots() {
        char[] roots = File.listRootsNative();
        File[] list = new File[roots.length];
        int i = roots.length;
        while (--i >= 0) {
            char d = roots[i];
            list[i] = d == '/' ? new File("/") : new File(String.valueOf(roots[i]) + ":/");
        }
        return list;
    }

    private native boolean mkdirNative(byte[] var1);

    public boolean mkdir() {
        return this.mkdirNative(this.absolute());
    }

    private native boolean renameToNative(byte[] var1, byte[] var2);

    public boolean renameTo(File destination) {
        return this.renameToNative(this.absolute(), destination.absolute());
    }

    private native boolean setLastModifiedNative(byte[] var1, long var2);

    public boolean setLastModified(long time) {
        return this.setLastModifiedNative(this.absolute(), time);
    }

    private native boolean setReadOnlyNative(byte[] var1);

    public boolean setReadOnly() {
        return this.setReadOnlyNative(this.absolute());
    }

    public String toString() {
        return this.getPath();
    }

    byte[] absolute() {
        if (this.absolute != null) {
            return this.absolute;
        }
        if (this.isAbsolute()) {
            this.absolute = this.path.getBytes();
            return this.absolute;
        }
        String userDirPath = this.normalize(System.getProperty("user.dir"));
        if (this.path.length() == 0) {
            this.absolute = userDirPath.getBytes();
            return this.absolute;
        }
        if (separatorChar == '\\' && userDirPath.length() == 2 && userDirPath.charAt(1) == ':') {
            this.absolute = (String.valueOf(userDirPath) + this.path).getBytes();
            return this.absolute;
        }
        int length = userDirPath.length();
        if (length > 0 && userDirPath.charAt(length - 1) == separatorChar) {
            this.absolute = (String.valueOf(userDirPath) + this.path).getBytes();
            return this.absolute;
        }
        this.absolute = (String.valueOf(userDirPath) + separator + this.path).getBytes();
        return this.absolute;
    }

    private String normalize(String name) {
        int length;
        int normalizedNamePtr = length = name.length();
        int i = length;
        char[] normalizedName = new char[length];
        boolean isNotRootDirectory = false;
        boolean regularChar = true;
        while (--i >= 0) {
            char c = name.charAt(i);
            if (c != '\\' && c != '/') {
                normalizedName[--normalizedNamePtr] = c;
                regularChar = true;
                isNotRootDirectory = true;
                continue;
            }
            if (regularChar) {
                normalizedName[--normalizedNamePtr] = separatorChar;
            }
            regularChar = false;
        }
        if (separatorChar == '\\' && length > 1) {
            if (!(name.charAt(0) != '\\' && name.charAt(0) != '/' || name.charAt(1) != '\\' && name.charAt(1) != '/')) {
                normalizedName[--normalizedNamePtr] = separatorChar;
            }
            if (name.charAt(1) == ':') {
                if (!(length <= 3 || name.charAt(2) != '\\' && name.charAt(2) != '/' || name.charAt(3) != '\\' && name.charAt(3) != '/')) {
                    normalizedName[--normalizedNamePtr] = name.charAt(0);
                    normalizedName[normalizedNamePtr + 1] = 58;
                    normalizedName[normalizedNamePtr + 2] = separatorChar;
                }
                if (length - normalizedNamePtr == 3 && normalizedName[length - 1] == '\\') {
                    isNotRootDirectory = false;
                }
            }
        }
        int nb = length - normalizedNamePtr;
        while (isNotRootDirectory && normalizedName[length - 1] == separatorChar) {
            --length;
            --nb;
        }
        return new String(normalizedName, normalizedNamePtr, nb);
    }

    public static File createTempFile(String prefix, String suffix) throws IOException {
        return File.createTempFile(prefix, suffix, null);
    }

    public static synchronized File createTempFile(String prefix, String suffix, File directory) throws IOException {
        if (prefix.length() < 3) {
            throw new IllegalArgumentException("Invalid prefix");
        }
        if (suffix == null) {
            suffix = ".tmp";
        }
        if (directory == null) {
            directory = new File(System.getProperty("java.io.tmpdir"));
        }
        directory.mkdirs();
        StringBuffer buffer = new StringBuffer(prefix);
        buffer.append(index++);
        buffer.append(suffix);
        File tempfile = new File(directory, buffer.toString());
        tempfile.createNewFile();
        return tempfile;
    }

    public boolean mkdirs() {
        File parent = this.getParentFile();
        if (parent != null && !parent.exists()) {
            parent.mkdirs();
        }
        return this.mkdir();
    }

    public String[] list(FilenameFilter filter) {
        String[] allfiles = this.list();
        if (filter != null && allfiles != null) {
            int i = allfiles.length;
            while (--i >= 0) {
                if (filter.accept(this, allfiles[i])) continue;
                allfiles[i] = null;
            }
        }
        return allfiles;
    }

    public File[] listFiles(FileFilter filter) {
        File[] allfiles = this.listFiles();
        if (filter != null && allfiles != null) {
            int i = allfiles.length;
            while (--i >= 0) {
                if (filter.accept(allfiles[i])) continue;
                allfiles[i] = null;
            }
        }
        return allfiles;
    }

    public boolean setReadable(boolean readable) {
        return false;
    }

    public boolean setWritable(boolean readable) {
        return false;
    }
}

