/*
 * Decompiled with CFR 0.152.
 */
package com.is2t.microej.workbench.ext.widget;

import com.is2t.microej.workbench.ext.SharedMessages;
import com.is2t.microej.workbench.ext.tools.Tools;
import com.is2t.microej.workbench.std.launch.ext.HiddenOption;
import com.is2t.microej.workbench.std.launch.ext.OptionChangedListener;
import com.is2t.microej.workbench.std.launch.ext.OptionValidator;
import com.is2t.microej.workbench.std.launch.ext.PageContent;
import com.is2t.microej.workbench.std.launch.ext.TextFieldOption;
import org.eclipse.osgi.util.NLS;

public class HiddenOptionForSize
extends HiddenOption
implements OptionChangedListener,
OptionValidator {
    protected TextFieldOption textField;
    protected long minValue;

    public HiddenOptionForSize(String outputProperty, TextFieldOption textField) {
        this(outputProperty, textField, 0L);
    }

    public HiddenOptionForSize(String outputProperty, TextFieldOption textField, long minSizeValue) {
        super(null, outputProperty, "");
        this.textField = textField;
        textField.addOptionChangedListener((OptionChangedListener)this);
        textField.setOptionValidator((OptionValidator)this);
        this.minValue = minSizeValue;
    }

    public long getValue() throws NumberFormatException {
        String value = this.textField.getSelection();
        return Tools.getMemorySize(value);
    }

    public void changed() {
        try {
            String value;
            long val = this.getValue();
            this.outputValue = value = String.valueOf(val);
        }
        catch (NumberFormatException numberFormatException) {}
    }

    public String getErrorMessage(PageContent arg0) {
        try {
            long val = this.getValue();
            String value = String.valueOf(val);
            if (val < this.minValue) {
                return NLS.bind((String)SharedMessages.ErrorIntervalOptionValidatorMin, (Object)this.textField.label.getText(), (Object)new Long(this.minValue));
            }
            this.outputValue = value;
            return null;
        }
        catch (NumberFormatException numberFormatException) {
            return NLS.bind((String)SharedMessages.ErrorSizeOptionValidator, (Object)this.textField.label.getText());
        }
    }
}

