/*
 * Decompiled with CFR 0.152.
 */
package com.is2t.microej.workbench.ext.validator;

import com.is2t.microej.workbench.ext.SharedMessages;
import com.is2t.microej.workbench.ext.tools.Tools;
import com.is2t.microej.workbench.ext.validator.IntOptionValidator;
import org.eclipse.osgi.util.NLS;

public class IntIntervalOptionValidator
extends IntOptionValidator {
    int minValue;
    int maxValue;
    boolean checkOnlyMinValue;
    boolean checkOnlyMaxValue;

    public IntIntervalOptionValidator(String label, int value, boolean checkOnlyMinValue) {
        super(label);
        this.minValue = value;
        this.checkOnlyMinValue = checkOnlyMinValue;
        this.checkOnlyMaxValue = !checkOnlyMinValue;
    }

    public IntIntervalOptionValidator(String label, int minValue, int maxValue) {
        super(label);
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.checkOnlyMaxValue = false;
        this.checkOnlyMinValue = false;
    }

    @Override
    public String validate(String text) {
        int value = Tools.parseInt(text);
        if (this.checkOnlyMinValue) {
            if (value < this.minValue) {
                return NLS.bind((String)SharedMessages.ErrorIntervalOptionValidatorMin, (Object[])new Object[]{this.label, Integer.toString(this.minValue)});
            }
        } else if (this.checkOnlyMaxValue) {
            if (value > this.maxValue) {
                return NLS.bind((String)SharedMessages.ErrorIntervalOptionValidatorMax, (Object[])new Object[]{this.label, Integer.toString(this.maxValue)});
            }
        } else if (value < this.minValue || value > this.maxValue) {
            return NLS.bind((String)SharedMessages.ErrorIntervalOptionValidator, (Object[])new Object[]{this.label, Integer.toString(this.minValue), Integer.toString(this.maxValue)});
        }
        return null;
    }
}

