/*
 * Decompiled with CFR 0.152.
 */
package ej.bluetooth.wbe.pages;

import com.is2t.microej.workbench.extension.Page;
import com.is2t.microej.workbench.extension.PagesResolver;
import com.is2t.microej.workbench.std.launch.ext.ComboOption;
import com.is2t.microej.workbench.std.launch.ext.Description;
import com.is2t.microej.workbench.std.launch.ext.Group;
import com.is2t.microej.workbench.std.launch.ext.LabelGroup;
import com.is2t.microej.workbench.std.launch.ext.PageContent;
import com.is2t.microej.workbench.std.launch.ext.TextFieldOption;
import com.is2t.microej.workbench.std.launch.ext.expr.ComboMatchingIndexes;
import com.is2t.microej.workbench.std.launch.ext.expr.Expression;
import ej.bluetooth.wbe.Messages;
import ej.bluetooth.wbe.PageUtils;
import ej.bluetooth.wbe.pages.SimulatorPage;

public class SimulatorBluetoothPage
implements Page {
    static final String MODE_LABEL = "Simulation mode";
    static final String MODE_DESCRIPTION = "Simulation mode";
    static final String MODE_PROPERTY = "s3.bluetooth.mode";
    static final String[] MODE_ITEMS = new String[]{"Stub", "Controller (over net)"};
    static final String[] MODE_VALUES = new String[]{"stub", "net"};
    static final int MODE_DEFAULT = 0;
    static final String HOST_LABEL = "Host or IP";
    static final String HOST_DESCRIPTION = "Host name or IP address of the controller";
    static final String HOST_PROPERTY = "s3.bluetooth.net.host";
    static final String HOST_DEFAULT = "192.168.x.y";
    static final String PORT_LABEL = "Port";
    static final String PORT_DESCRIPTION = "TCP port of the controller";
    static final String PORT_PROPERTY = "s3.bluetooth.net.port";
    static final int PORT_DEFAULT = 80;
    static final String CONNECTION_TIMEOUT_LABEL = "Connection timeout (ms)";
    static final String CONNECTION_TIMEOUT_DESCRIPTION = "Timeout of the connection with the controller";
    static final String CONNECTION_TIMEOUT_PROPERTY = "s3.bluetooth.net.timeout";
    static final int CONNECTION_TIMEOUT_DEFAULT = 5000;

    public String getParent() {
        return SimulatorPage.class.getName();
    }

    public String getName() {
        return Messages.CategoryBluetooth;
    }

    public Description getDescription() {
        return null;
    }

    public PageContent getContent() {
        ComboOption modeOption = this.createModeOption();
        ComboMatchingIndexes isNetModeExpression = new ComboMatchingIndexes(modeOption, new int[]{1});
        PageContent[] connectionOptions = new PageContent[]{this.createHostOption((Expression)isNetModeExpression), this.createPortOption((Expression)isNetModeExpression), this.createConnectionTimeoutOption((Expression)isNetModeExpression)};
        LabelGroup connectionGroup = new LabelGroup(Messages.LabelConnectionOptions, connectionOptions, 1);
        return new Group(new PageContent[]{modeOption, connectionGroup}, 1);
    }

    public void finalize(PagesResolver resolver) {
    }

    public Expression getVisibility() {
        return null;
    }

    public ComboOption createModeOption() {
        return PageUtils.createComboOption(MODE_PROPERTY, MODE_ITEMS, MODE_VALUES, 0, "Simulation mode", "Simulation mode");
    }

    public PageContent createHostOption(Expression enableCondition) {
        TextFieldOption option = PageUtils.createStringOption(HOST_PROPERTY, HOST_DEFAULT, HOST_LABEL, HOST_DESCRIPTION);
        option.setEnableCondition(enableCondition);
        return option;
    }

    public PageContent createPortOption(Expression enableCondition) {
        TextFieldOption option = PageUtils.createIntOption(PORT_PROPERTY, 80, PORT_LABEL, PORT_DESCRIPTION);
        option.setEnableCondition(enableCondition);
        return option;
    }

    public PageContent createConnectionTimeoutOption(Expression enableCondition) {
        TextFieldOption option = PageUtils.createIntOption(CONNECTION_TIMEOUT_PROPERTY, 5000, CONNECTION_TIMEOUT_LABEL, CONNECTION_TIMEOUT_DESCRIPTION);
        option.setEnableCondition(enableCondition);
        return option;
    }
}

