/*
 * Decompiled with CFR 0.152.
 */
package com.is2t.s3.io;

import com.is2t.s3.io.File;
import com.is2t.s3.io.FileDescriptor;
import com.is2t.s3.io.FileNotFoundException;
import com.is2t.tools.ArrayTools;
import java.io.IOException;
import java.io.InputStream;

public class FileInputStream
extends InputStream {
    private FileDescriptor fd;

    public FileInputStream(String filename) throws IOException {
        this(new File(filename));
    }

    public FileInputStream(FileDescriptor fd) throws IOException {
        this.fd = fd;
        if (this.fd == null) {
            throw new NullPointerException();
        }
    }

    public FileInputStream(File file) throws IOException {
        if (file.isDirectory()) {
            throw new FileNotFoundException(file.getPath());
        }
        this.fd = new FileDescriptor();
        if (this.openNative(file.absolute()) != 0) {
            throw new FileNotFoundException(file.getPath());
        }
    }

    private native int openNative(byte[] var1);

    public native int available() throws IOException;

    private native int readByteNative(int var1);

    public int read() throws IOException {
        if (this.fd.valid()) {
            return this.readByteNative(this.fd.descriptor);
        }
        throw new IOException();
    }

    private native int readNative(byte[] var1, int var2, int var3, int var4);

    public int read(byte[] buf, int off, int len) throws IOException {
        ArrayTools.checkBounds((byte[])buf, (int)off, (int)len);
        if (this.fd.valid()) {
            return this.readNative(buf, off, len, this.fd.descriptor);
        }
        throw new IOException();
    }

    public native void close() throws IOException;

    public native long skip(long var1) throws IOException;
}

