/*
 * Decompiled with CFR 0.152.
 */
package ej.microvg.path;

import ej.microvg.CommandDecoder;
import ej.microvg.Util;
import ej.microvg.image.pathdata.SingleArrayPathDataFP32;
import ej.microvg.path.LLVGDynamicPathImpl;
import java.awt.geom.GeneralPath;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class DynamicPath
implements LLVGDynamicPathImpl,
CommandDecoder {
    private static final int PATH_OFFSET_DATA_SIZE = 0;
    private static final int PATH_HEADER_SIZE = 4;
    private static final int PATH_COORD_SIZE = 4;

    @Override
    public int initializePath(byte[] path, int length) {
        if (length < this.getPathHeaderSize()) {
            return this.getPathHeaderSize();
        }
        this.setPathDataSize(path, 0);
        return 0;
    }

    @Override
    public int getPathHeaderSize() {
        return 4;
    }

    private int getPathCommandSize(int nbParams) {
        return (nbParams + 1) * 4;
    }

    @Override
    public int appendPathCommand(byte[] data, int offset, int cmd) {
        offset = Util.append(data, offset, cmd);
        return offset;
    }

    @Override
    public int appendPathCommand(byte[] data, int offset, int cmd, float x, float y) {
        offset = Util.append(data, offset, cmd);
        offset = Util.append(data, offset, x);
        offset = Util.append(data, offset, y);
        return offset;
    }

    @Override
    public int appendPathCommand(byte[] data, int offset, int cmd, float x1, float y1, float x2, float y2) {
        offset = Util.append(data, offset, cmd);
        offset = Util.append(data, offset, x1);
        offset = Util.append(data, offset, y1);
        offset = Util.append(data, offset, x2);
        offset = Util.append(data, offset, y2);
        return offset;
    }

    @Override
    public int appendPathCommand(byte[] data, int offset, int cmd, float x1, float y1, float x2, float y2, float x3, float y3) {
        offset = Util.append(data, offset, cmd);
        offset = Util.append(data, offset, x1);
        offset = Util.append(data, offset, y1);
        offset = Util.append(data, offset, x2);
        offset = Util.append(data, offset, y2);
        offset = Util.append(data, offset, x3);
        offset = Util.append(data, offset, y3);
        return offset;
    }

    @Override
    public int extendPath(byte[] path, int length, int cmd, int nbFields) {
        int extraSize = this.getPathCommandSize(nbFields);
        int newDataSize = this.getPathDataSize(path) + extraSize;
        if (length > this.getPathDataOffset(path) + newDataSize) {
            this.setPathDataSize(path, newDataSize);
            return 0;
        }
        return extraSize;
    }

    @Override
    public void reducePath(byte[] path, int cmd, int nbFields) {
        int size = this.getPathCommandSize(nbFields);
        int newDataSize = this.getPathDataSize(path) - size;
        this.setPathDataSize(path, newDataSize);
    }

    private void setPathDataSize(byte[] path, int value) {
        Util.append(path, 0, value);
    }

    @Override
    public int getPathDataSize(byte[] path) {
        return Util.getInt(path, 0);
    }

    @Override
    public int getPathDataOffset(byte[] path) {
        return this.getPathHeaderSize();
    }

    @Override
    public int getPathFreeOffset(byte[] path) {
        return this.getPathDataOffset(path) + this.getPathDataSize(path);
    }

    @Override
    public GeneralPath createGeneralPath(byte[] path) {
        ByteBuffer buffer = ByteBuffer.wrap(path, this.getPathDataOffset(path), this.getPathDataSize(path)).order(ByteOrder.LITTLE_ENDIAN);
        return Util.toPath(new SingleArrayPathDataFP32(buffer), this);
    }

    @Override
    public int decodeCommand(int command) {
        return command;
    }
}

