/*
 * Decompiled with CFR 0.152.
 */
package ej.microvg.image.raw;

import ej.microvg.MatrixHelper;
import ej.microvg.image.raw.GroupElement;
import ej.microvg.image.raw.ImageElement;
import ej.microvg.paint.PaintVisitor;

public class TransformedGroupElement
extends GroupElement {
    private final float[] transformationMatrix;

    public TransformedGroupElement(float[] transformationMatrix) {
        this.transformationMatrix = transformationMatrix;
    }

    private TransformedGroupElement(TransformedGroupElement element, PaintVisitor transformer) {
        super(element, transformer);
        this.transformationMatrix = element.transformationMatrix;
    }

    @Override
    public float[] updateMatrix(float[] globalMatrix, long atTime, boolean applyAnimations) {
        float[] matrix = MatrixHelper.create(globalMatrix);
        MatrixHelper.concatenate(matrix, this.transformationMatrix);
        return matrix;
    }

    @Override
    public ImageElement transform(PaintVisitor transformer) {
        return new TransformedGroupElement(this, transformer);
    }
}

