/*
 * Decompiled with CFR 0.152.
 */
package ej.microvg.image.raw;

import ej.microvg.MatrixHelper;
import ej.microvg.image.raw.GroupAnimation;
import ej.microvg.image.raw.PathInterpolator;

public class ScaleAnimation
extends GroupAnimation {
    private final float scaleXFrom;
    private final float scaleXTo;
    private final float scaleYFrom;
    private final float scaleYTo;
    private final float pivotX;
    private final float pivotY;

    public ScaleAnimation(int begin, int duration, int keepDuration, PathInterpolator pathInterpolator, float scaleXFrom, float scaleXTo, float scaleYFrom, float scaleYTo, float pivotX, float pivotY) {
        super(begin, duration, keepDuration, pathInterpolator);
        this.scaleXFrom = scaleXFrom;
        this.scaleXTo = scaleXTo;
        this.scaleYFrom = scaleYFrom;
        this.scaleYTo = scaleYTo;
        this.pivotX = pivotX;
        this.pivotY = pivotY;
    }

    @Override
    public void modifyMatrixAtTime(float[] matrix, long atTime) {
        float scaleX = this.getScale(this.scaleXFrom, this.scaleXTo, atTime);
        float scaleY = this.getScale(this.scaleYFrom, this.scaleYTo, atTime);
        MatrixHelper.translate(matrix, this.pivotX, this.pivotY);
        MatrixHelper.scale(matrix, scaleX, scaleY);
        MatrixHelper.translate(matrix, -this.pivotX, -this.pivotY);
    }

    private float getScale(float from, float to, long atTime) {
        float transformRatio = this.getTransformRatioAtTime(atTime);
        if (from < to) {
            return (float)((double)from * Math.pow(to / from, transformRatio));
        }
        return (float)((double)to * Math.pow(from / to, 1.0f - transformRatio));
    }
}

