/*
 * Decompiled with CFR 0.152.
 */
package ej.microvg.image.raw;

import ej.microvg.MatrixHelper;
import ej.microvg.image.raw.GroupAnimation;
import ej.microvg.image.raw.PathInterpolator;

public class RotateAnimation
extends GroupAnimation {
    private final float startAngle;
    private final float rotationAngle;
    private final float startRotationCenterX;
    private final float startRotationCenterY;
    private final float rotationTranslationCenterX;
    private final float rotationTranslationCenterY;

    public RotateAnimation(int begin, int duration, int keepDuration, PathInterpolator pathInterpolator, float startAngle, float rotationAngle, float startRotationCenterX, float startRotationCenterY, float rotationTranslationCenterX, float rotationTranslationCenterY) {
        super(begin, duration, keepDuration, pathInterpolator);
        this.startAngle = startAngle;
        this.rotationAngle = rotationAngle;
        this.startRotationCenterX = startRotationCenterX;
        this.startRotationCenterY = startRotationCenterY;
        this.rotationTranslationCenterX = rotationTranslationCenterX;
        this.rotationTranslationCenterY = rotationTranslationCenterY;
    }

    @Override
    public void modifyMatrixAtTime(float[] matrix, long atTime) {
        float transformRatio = this.getTransformRatioAtTime(atTime);
        MatrixHelper.translate(matrix, this.startRotationCenterX + this.rotationTranslationCenterX * transformRatio, this.startRotationCenterY + this.rotationTranslationCenterY * transformRatio);
        MatrixHelper.rotate(matrix, this.startAngle + this.rotationAngle * transformRatio);
        MatrixHelper.translate(matrix, -this.startRotationCenterX - this.rotationTranslationCenterX * transformRatio, -this.startRotationCenterY - this.rotationTranslationCenterY * transformRatio);
    }
}

