/*
 * Decompiled with CFR 0.152.
 */
package ej.microvg.image.raw;

import ej.microui.display.MicroUIGraphicsContext;
import ej.microvg.MatrixHelper;
import ej.microvg.MicroVGImage;
import ej.microvg.Util;
import ej.microvg.VectorGraphicsNatives;
import ej.microvg.image.ColorMatrixVisitor;
import ej.microvg.image.ImageDecoder;
import ej.microvg.image.raw.AlphaAnimation;
import ej.microvg.image.raw.AnimatedColorElement;
import ej.microvg.image.raw.AnimatedGradientElement;
import ej.microvg.image.raw.AnimatedGroupElement;
import ej.microvg.image.raw.ColorAnimation;
import ej.microvg.image.raw.ColorElement;
import ej.microvg.image.raw.GradientElement;
import ej.microvg.image.raw.GroupAnimation;
import ej.microvg.image.raw.GroupElement;
import ej.microvg.image.raw.ImageClip;
import ej.microvg.image.raw.ImageElement;
import ej.microvg.image.raw.PathDataAnimation;
import ej.microvg.image.raw.PathInterpolator;
import ej.microvg.image.raw.RotateAnimation;
import ej.microvg.image.raw.ScaleAnimation;
import ej.microvg.image.raw.TransformedGroupElement;
import ej.microvg.image.raw.TranslateAnimation;
import ej.microvg.image.raw.TranslateXYAnimation;
import ej.microvg.paint.PaintVisitor;
import ej.microvg.paint.VGPaint;
import java.awt.geom.GeneralPath;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayDeque;

public class RawImage
implements MicroVGImage {
    public static final int LLVG_RAW_VERSION = 1;
    private static final int RAW_FLAG_OVERLAP_PATH = Integer.MIN_VALUE;
    private static final int KIND_LAST = 0;
    private static final int KIND_PATH_COLOR = 1;
    private static final int KIND_PATH_GRADIENT = 2;
    private static final int KIND_GROUP_TRANSFORM = 3;
    private static final int KIND_GROUP_ANIMATE = 4;
    private static final int KIND_GROUP_END = 5;
    private static final int KIND_PATH_COLOR_ANIMATE = 6;
    private static final int KIND_PATH_GRADIENT_ANIMATE = 7;
    private static final int METADATA_OFFSET_F32_WIDTH = 0;
    private static final int METADATA_OFFSET_F32_HEIGHT = 1;
    private static final int METADATA_OFFSET_U32_DURATION = 2;
    private static final int METADATA_OFFSET_U32_FLAGS = 3;
    private static final int METADATA_FLAG_OVERLAP_PATH = 1;
    private static ImageDecoder engine;
    private final ImageElement firstElement;
    private final float width;
    private final float height;

    public static RawImage createRawImage(byte[] data, int[] metadata) {
        RawImage image = null;
        if (RawImage.isRawImage(data)) {
            try {
                ByteBuffer is = ByteBuffer.wrap(data, 8, data.length - 8).order(ByteOrder.LITTLE_ENDIAN);
                float width = is.getFloat();
                float height = is.getFloat();
                int flags = is.getInt();
                int duration = flags & 0xFFFFFF;
                boolean hasOverlappingPaths = (flags & Integer.MIN_VALUE) == Integer.MIN_VALUE;
                int firstElementOffset = is.getInt();
                engine = VectorGraphicsNatives.getImageDecoder();
                GroupElement master = new GroupElement();
                RawImage.parseElements(is, firstElementOffset, master);
                image = new RawImage(master, width, height);
                if (metadata != null) {
                    metadata[0] = Float.floatToIntBits(width);
                    metadata[1] = Float.floatToIntBits(height);
                    metadata[2] = duration;
                    metadata[3] = hasOverlappingPaths ? 1 : 0;
                }
            }
            catch (Exception exception) {}
        }
        return image;
    }

    private static boolean isRawImage(byte[] source) {
        return source[0] == 77 && source[1] == 69 && source[2] == 74 && source[3] == 95 && source[4] == 77 && source[5] == 86 && source[6] == 71 && source[7] == 1;
    }

    private static void parseElements(ByteBuffer reader, int offset, GroupElement parent) throws IOException {
        int kind;
        ArrayDeque<GroupElement> parents = new ArrayDeque<GroupElement>();
        parents.push(parent);
        ByteBuffer is = Util.derive(reader, offset);
        do {
            kind = Byte.toUnsignedInt(is.get());
            switch (kind) {
                case 0: {
                    break;
                }
                case 1: {
                    RawImage.parseColorElement((GroupElement)parents.peek(), is);
                    break;
                }
                case 2: {
                    RawImage.parseGradientElement((GroupElement)parents.peek(), is);
                    break;
                }
                case 3: {
                    RawImage.parseGroupTransformElement(parents, is);
                    break;
                }
                case 4: {
                    RawImage.parseGroupAnimateElement(parents, is);
                    break;
                }
                case 5: {
                    RawImage.parseEndGroup(parents, is);
                    break;
                }
                case 6: {
                    RawImage.parseColorAnimateElement((GroupElement)parents.peek(), is);
                    break;
                }
                case 7: {
                    RawImage.parseGradientAnimateElement((GroupElement)parents.peek(), is);
                    break;
                }
                default: {
                    throw new IOException("invalid kind: 0x" + Integer.toHexString(kind));
                }
            }
        } while (kind != 0);
    }

    private static void parseColorElement(GroupElement parent, ByteBuffer is) {
        int fill = engine.decodeFillRule(Byte.toUnsignedInt(is.get()));
        Util.skip(is, 2);
        int offsetPath = is.getInt();
        int color = engine.decodeColor(is.getInt());
        GeneralPath pathData = RawImage.getPathData(is, offsetPath);
        parent.addChild(new ColorElement(pathData, fill, color));
    }

    private static void parseGradientElement(GroupElement parent, ByteBuffer is) {
        int fill = engine.decodeFillRule(Byte.toUnsignedInt(is.get()));
        Util.skip(is, 2);
        int offsetPath = is.getInt();
        int offsetGradient = is.getInt();
        GeneralPath pathData = RawImage.getPathData(is, offsetPath);
        VGPaint gradient = RawImage.getGradient(is, offsetGradient);
        parent.addChild(new GradientElement(pathData, fill, gradient));
    }

    private static void parseEndGroup(ArrayDeque<GroupElement> parents, ByteBuffer is) {
        parents.pop();
        Util.skip(is, 3);
    }

    private static void parseGroupTransformElement(ArrayDeque<GroupElement> parents, ByteBuffer is) {
        Util.skip(is, 3);
        TransformedGroupElement newGroup = new TransformedGroupElement(RawImage.getMatrix(is));
        parents.peek().addChild(newGroup);
        parents.push(newGroup);
    }

    private static void parseGroupAnimateElement(ArrayDeque<GroupElement> parents, ByteBuffer is) {
        Util.skip(is, 1);
        is.getChar();
        int nbTranslates = Byte.toUnsignedInt(is.get());
        int nbTranslatesXY = Byte.toUnsignedInt(is.get());
        int nbRotates = Byte.toUnsignedInt(is.get());
        int nbScales = Byte.toUnsignedInt(is.get());
        float scaleX = is.getFloat();
        float scaleY = is.getFloat();
        float translateX = is.getFloat();
        float translateY = is.getFloat();
        float pivotX = is.getFloat();
        float pivotY = is.getFloat();
        float rotation = is.getFloat();
        TranslateAnimation[] translates = RawImage.getTranslateAnimations(is, nbTranslates);
        TranslateXYAnimation[] translatesXY = RawImage.getTranslateXYAnimations(is, nbTranslatesXY);
        GroupAnimation[] rotates = RawImage.getRotateAnimations(is, nbRotates);
        GroupAnimation[] scales = RawImage.getScaleAnimations(is, nbScales);
        GroupAnimation[] tr = nbTranslates > 0 ? translates : translatesXY;
        AnimatedGroupElement newGroup = new AnimatedGroupElement(scales, rotates, tr, scaleX, scaleY, translateX, translateY, rotation, pivotX, pivotY);
        parents.peek().addChild(newGroup);
        parents.push(newGroup);
    }

    private static void parseColorAnimateElement(GroupElement parent, ByteBuffer is) {
        int fill = engine.decodeFillRule(Byte.toUnsignedInt(is.get()));
        Util.skip(is, 2);
        int offsetPath = is.getInt();
        int color = engine.decodeColor(is.getInt());
        GeneralPath pathData = RawImage.getPathData(is, offsetPath);
        int nbColors = Byte.toUnsignedInt(is.get());
        int nbAlphas = Byte.toUnsignedInt(is.get());
        int nbPathData = Byte.toUnsignedInt(is.get());
        Util.skip(is, 1);
        is.getChar();
        Util.skip(is, 2);
        ColorAnimation[] colors = RawImage.getColorAnimations(is, nbColors);
        AlphaAnimation[] alphas = RawImage.getAlphaAnimations(is, nbAlphas);
        PathDataAnimation[] paths = RawImage.getPathDataAnimations(is, nbPathData);
        parent.addChild(new AnimatedColorElement(pathData, fill, color, colors, alphas, paths));
    }

    private static void parseGradientAnimateElement(GroupElement parent, ByteBuffer is) {
        int fill = engine.decodeFillRule(Byte.toUnsignedInt(is.get()));
        Util.skip(is, 2);
        int offsetPath = is.getInt();
        int offsetGradient = is.getInt();
        GeneralPath pathData = RawImage.getPathData(is, offsetPath);
        VGPaint gradient = RawImage.getGradient(is, offsetGradient);
        int nbAlphas = Byte.toUnsignedInt(is.get());
        int nbPathData = Byte.toUnsignedInt(is.get());
        is.getChar();
        AlphaAnimation[] alphas = RawImage.getAlphaAnimations(is, nbAlphas);
        PathDataAnimation[] paths = RawImage.getPathDataAnimations(is, nbPathData);
        parent.addChild(new AnimatedGradientElement(pathData, fill, gradient, alphas, paths));
    }

    private static GeneralPath getPathData(ByteBuffer reader, int offset) {
        ByteBuffer is = Util.derive(reader, offset);
        return Util.toPath(VectorGraphicsNatives.getImageDecoder().decodePath(is), VectorGraphicsNatives.getImageDecoder());
    }

    private static VGPaint getGradient(ByteBuffer reader, int offset) {
        ByteBuffer is = Util.derive(reader, offset);
        return VectorGraphicsNatives.getImageDecoder().decodeGradient(is);
    }

    private static float[] getMatrix(ByteBuffer is) {
        float[] matrix = MatrixHelper.create();
        int i = 0;
        while (i < matrix.length) {
            matrix[i] = is.getFloat();
            ++i;
        }
        return matrix;
    }

    private static TranslateAnimation[] getTranslateAnimations(ByteBuffer is, int count) {
        TranslateAnimation[] translates = new TranslateAnimation[count];
        int i = 0;
        while (i < count) {
            int duration = is.getInt();
            int begin = is.getInt();
            int keep = is.getInt();
            int pathInterpolatorOffset = is.getInt();
            float startX = is.getFloat();
            float startY = is.getFloat();
            float translateX = is.getFloat();
            float translateY = is.getFloat();
            PathInterpolator pi = RawImage.getPathInterpolator(is, pathInterpolatorOffset);
            translates[i] = new TranslateAnimation(begin, duration, keep, pi, startX, startY, translateX, translateY);
            ++i;
        }
        return translates;
    }

    private static ScaleAnimation[] getScaleAnimations(ByteBuffer is, int count) {
        ScaleAnimation[] scales = new ScaleAnimation[count];
        int i = 0;
        while (i < count) {
            int duration = is.getInt();
            int begin = is.getInt();
            int keep = is.getInt();
            int pathInterpolatorOffset = is.getInt();
            float scaleXFrom = is.getFloat();
            float scaleXTo = is.getFloat();
            float scaleYFrom = is.getFloat();
            float scaleYTo = is.getFloat();
            float pivotX = is.getFloat();
            float pivotY = is.getFloat();
            PathInterpolator pi = RawImage.getPathInterpolator(is, pathInterpolatorOffset);
            scales[i] = new ScaleAnimation(begin, duration, keep, pi, scaleXFrom, scaleXTo, scaleYFrom, scaleYTo, pivotX, pivotY);
            ++i;
        }
        return scales;
    }

    private static RotateAnimation[] getRotateAnimations(ByteBuffer is, int count) {
        RotateAnimation[] rotates = new RotateAnimation[count];
        int i = 0;
        while (i < count) {
            int duration = is.getInt();
            int begin = is.getInt();
            int keep = is.getInt();
            int pathInterpolatorOffset = is.getInt();
            float startAngle = is.getFloat();
            float rotationAngle = is.getFloat();
            float startRotationCenterX = is.getFloat();
            float startRotationCenterY = is.getFloat();
            float rotationTranslationCenterX = is.getFloat();
            float rotationTranslationCenterY = is.getFloat();
            PathInterpolator pi = RawImage.getPathInterpolator(is, pathInterpolatorOffset);
            rotates[i] = new RotateAnimation(begin, duration, keep, pi, startAngle, rotationAngle, startRotationCenterX, startRotationCenterY, rotationTranslationCenterX, rotationTranslationCenterY);
            ++i;
        }
        return rotates;
    }

    private static TranslateXYAnimation[] getTranslateXYAnimations(ByteBuffer is, int count) {
        TranslateXYAnimation[] translates = new TranslateXYAnimation[count];
        int i = 0;
        while (i < count) {
            int duration = is.getInt();
            int begin = is.getInt();
            int keep = is.getInt();
            int pathInterpolatorOffset = is.getInt();
            int translateInterpolatorOffset = is.getInt();
            PathInterpolator pi0 = RawImage.getPathInterpolator(is, pathInterpolatorOffset);
            PathInterpolator pi1 = RawImage.getPathInterpolator(is, translateInterpolatorOffset);
            translates[i] = new TranslateXYAnimation(begin, duration, keep, pi0, pi1);
            ++i;
        }
        return translates;
    }

    private static PathInterpolator getPathInterpolator(ByteBuffer reader, int offset) {
        ByteBuffer is = Util.derive(reader, offset);
        int size = is.getInt();
        short[] endTimeRatio = new short[size];
        float[] startX = new float[size];
        float[] startY = new float[size];
        int i = 0;
        while (i < size) {
            endTimeRatio[i] = is.getShort();
            ++i;
        }
        if ((size & 1) != 0) {
            Util.skip(is, 2);
        }
        i = 0;
        while (i < size) {
            startX[i] = is.getFloat();
            ++i;
        }
        i = 0;
        while (i < size) {
            startY[i] = is.getFloat();
            ++i;
        }
        return new PathInterpolator(endTimeRatio, startX, startY);
    }

    private static ColorAnimation[] getColorAnimations(ByteBuffer is, int count) {
        ColorAnimation[] colors = new ColorAnimation[count];
        int i = 0;
        while (i < count) {
            int duration = is.getInt();
            int begin = is.getInt();
            int keep = is.getInt();
            int pathInterpolatorOffset = is.getInt();
            int startColor = engine.decodeColor(is.getInt());
            int endColor = engine.decodeColor(is.getInt());
            PathInterpolator pi = RawImage.getPathInterpolator(is, pathInterpolatorOffset);
            colors[i] = new ColorAnimation(begin, duration, keep, pi, startColor, endColor);
            ++i;
        }
        return colors;
    }

    private static AlphaAnimation[] getAlphaAnimations(ByteBuffer is, int count) {
        AlphaAnimation[] alphas = new AlphaAnimation[count];
        int i = 0;
        while (i < count) {
            int duration = is.getInt();
            int begin = is.getInt();
            int keep = is.getInt();
            int pathInterpolatorOffset = is.getInt();
            byte startAlpha = is.get();
            byte endAlpha = is.get();
            Util.skip(is, 2);
            PathInterpolator pi = RawImage.getPathInterpolator(is, pathInterpolatorOffset);
            alphas[i] = new AlphaAnimation(begin, duration, keep, pi, startAlpha, endAlpha);
            ++i;
        }
        return alphas;
    }

    private static PathDataAnimation[] getPathDataAnimations(ByteBuffer is, int count) {
        PathDataAnimation[] pathDatas = new PathDataAnimation[count];
        int i = 0;
        while (i < count) {
            int duration = is.getInt();
            int begin = is.getInt();
            int keep = is.getInt();
            int pathInterpolatorOffset = is.getInt();
            int offsetPathFrom = is.getInt();
            int offsetPathTo = is.getInt();
            PathInterpolator pi = RawImage.getPathInterpolator(is, pathInterpolatorOffset);
            GeneralPath from = RawImage.getPathData(is, offsetPathFrom);
            GeneralPath to = RawImage.getPathData(is, offsetPathTo);
            pathDatas[i] = new PathDataAnimation(begin, duration, keep, pi, from, to);
            ++i;
        }
        return pathDatas;
    }

    private RawImage(ImageElement firstElement, float width, float height) {
        this.firstElement = firstElement;
        this.width = width;
        this.height = height;
    }

    @Override
    public int draw(MicroUIGraphicsContext gc, float[] matrix, int alpha, long elapsedTime, float[] colorMatrix) {
        int x = 0;
        int y = 0;
        if (ImageClip.apply(gc, matrix, x, y, (int)this.width, (int)this.height)) {
            if (255 == alpha) {
                if (0L > elapsedTime) {
                    if (colorMatrix == null) {
                        this.firstElement.draw(gc, matrix);
                    } else {
                        this.firstElement.drawTransformed(gc, matrix, new ColorMatrixVisitor(colorMatrix));
                    }
                } else if (colorMatrix == null) {
                    this.firstElement.drawAnimated(gc, matrix, elapsedTime);
                } else {
                    this.firstElement.drawTransformedAnimated(gc, matrix, elapsedTime, new ColorMatrixVisitor(colorMatrix));
                }
            } else if (0L > elapsedTime) {
                assert (colorMatrix == null);
                this.firstElement.draw(gc, matrix, alpha);
            } else {
                assert (colorMatrix == null);
                this.firstElement.drawAnimated(gc, matrix, alpha, elapsedTime);
            }
            ImageClip.revert(gc);
        }
        return 0;
    }

    @Override
    public RawImage transform(PaintVisitor transformer) {
        return new RawImage(this.firstElement.transform(transformer), this.width, this.height);
    }
}

