/*
 * Decompiled with CFR 0.152.
 */
package ej.microvg.image.raw;

import ej.microvg.Util;

public class PathInterpolator {
    private static int TIMERATIO_RANGE = 65535;
    private static int TIMERATIO_OFFSET = TIMERATIO_RANGE / 2 + 1;
    private final short[] endTimeRatio;
    private final float[] startX;
    private final float[] startY;

    public PathInterpolator(short[] endTimeRatio, float[] startX, float[] startY) {
        this.endTimeRatio = endTimeRatio;
        this.startX = startX;
        this.startY = startY;
    }

    public float getXAt(float timeRatio) {
        return this.getAt(this.startX, timeRatio);
    }

    public float getYAt(float timeRatio) {
        return this.getAt(this.startY, timeRatio);
    }

    private float getAt(float[] values, float timeRatio) {
        timeRatio = Util.limit(timeRatio, 0.0f, 1.0f);
        int timeRatioShort = (int)(timeRatio * (float)TIMERATIO_RANGE);
        int origin = 0;
        short[] endTimeRatio = this.endTimeRatio;
        int i = 0;
        while (i < endTimeRatio.length - 1) {
            int end = endTimeRatio[i] + TIMERATIO_OFFSET;
            if (timeRatioShort <= end) {
                float segPosition = (float)(timeRatioShort - origin) / (float)(end - origin);
                float segStartValue = values[i];
                float segEndValue = values[i + 1];
                return segStartValue * (1.0f - segPosition) + segEndValue * segPosition;
            }
            origin = end;
            ++i;
        }
        return 0.0f;
    }
}

