/*
 * Decompiled with CFR 0.152.
 */
package ej.microvg.image.raw;

import ej.microvg.image.raw.Animation;
import ej.microvg.image.raw.PathInterpolator;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;

public class PathDataAnimation
extends Animation {
    private final GeneralPath pathFrom;
    private final GeneralPath pathTo;

    public PathDataAnimation(int begin, int duration, int keepDuration, PathInterpolator pathInterpolator, GeneralPath pathFrom, GeneralPath pathTo) {
        super(begin, duration, keepDuration, pathInterpolator);
        this.pathFrom = pathFrom;
        this.pathTo = pathTo;
    }

    public GeneralPath updatePathAtTime(long atTime, GeneralPath path) {
        int begin = this.begin;
        int duration = this.duration;
        int keepDuration = this.keepDuration;
        if (atTime >= (long)begin) {
            if (atTime < (long)(begin + duration)) {
                float transformRatio = this.getTransformRatioAtTime(atTime - (long)begin);
                return this.mergePaths(this.pathFrom, this.pathTo, transformRatio);
            }
            if (atTime < (long)(begin + duration + keepDuration) || -1 == keepDuration) {
                return this.pathTo;
            }
        }
        return path;
    }

    private GeneralPath mergePaths(GeneralPath pathFrom, GeneralPath pathTo, float ratio) {
        GeneralPath pathDest = new GeneralPath();
        double[] coordsFrom = new double[6];
        double[] coordsTo = new double[6];
        PathIterator piFrom = pathFrom.getPathIterator(null);
        PathIterator piTo = pathTo.getPathIterator(null);
        while (!piFrom.isDone()) {
            piTo.currentSegment(coordsTo);
            piTo.next();
            switch (piFrom.currentSegment(coordsFrom)) {
                case 0: {
                    this.mergeCoordinates(coordsFrom, coordsTo, 2, ratio);
                    pathDest.moveTo(coordsFrom[0], coordsFrom[1]);
                    break;
                }
                case 1: {
                    this.mergeCoordinates(coordsFrom, coordsTo, 2, ratio);
                    pathDest.lineTo(coordsFrom[0], coordsFrom[1]);
                    break;
                }
                case 2: {
                    this.mergeCoordinates(coordsFrom, coordsTo, 4, ratio);
                    pathDest.quadTo(coordsFrom[0], coordsFrom[1], coordsFrom[2], coordsFrom[3]);
                    break;
                }
                case 3: {
                    this.mergeCoordinates(coordsFrom, coordsTo, 6, ratio);
                    pathDest.curveTo(coordsFrom[0], coordsFrom[1], coordsFrom[2], coordsFrom[3], coordsFrom[4], coordsFrom[5]);
                    break;
                }
                case 4: {
                    pathDest.closePath();
                }
            }
            piFrom.next();
        }
        return pathDest;
    }

    private void mergeCoordinates(double[] from, double[] to, int length, float ratio) {
        int j = 0;
        while (j < length) {
            from[j] = (double)ratio * to[j] + (double)(1.0f - ratio) * from[j];
            ++j;
        }
    }
}

