/*
 * Decompiled with CFR 0.152.
 */
package ej.microvg.image.raw;

import ej.microui.display.MicroUIGraphicsContext;
import ej.microvg.VGEngine;
import java.awt.Rectangle;

public class ImageClip {
    private ImageClip() {
    }

    public static boolean apply(MicroUIGraphicsContext g, float[] matrix, int x, int y, int width, int height) {
        boolean outside = false;
        int x0 = (int)matrix[2];
        int y0 = (int)matrix[5];
        int x1 = (int)((float)width * matrix[0] + matrix[2]);
        int y1 = (int)((float)width * matrix[3] + matrix[5]);
        int x2 = (int)((float)height * matrix[1] + matrix[2]);
        int y2 = (int)((float)height * matrix[4] + matrix[5]);
        int x3 = (int)((float)width * matrix[0] + (float)height * matrix[1] + matrix[2]);
        int y3 = (int)((float)width * matrix[3] + (float)height * matrix[4] + matrix[5]);
        int renderAreaX = Math.min(x0, Math.min(x1, Math.min(x2, x3)));
        int renderAreaY = Math.min(y0, Math.min(y1, Math.min(y2, y3)));
        int renderAreaWidth = Math.max(x0, Math.max(x1, Math.max(x2, x3))) - renderAreaX;
        int renderAreaHeight = Math.max(y0, Math.max(y1, Math.max(y2, y3))) - renderAreaY;
        renderAreaX += x;
        renderAreaY += y;
        int masterClipX = g.getClipX1();
        int masterClipY = g.getClipY1();
        int masterClipWidth = g.getClipX2() - g.getClipX1() + 1;
        int masterClipHeight = g.getClipY2() - g.getClipY1() + 1;
        if (renderAreaX < masterClipX) {
            renderAreaWidth -= masterClipX - renderAreaX;
            renderAreaX = masterClipX;
        }
        if (renderAreaY < masterClipY) {
            renderAreaHeight -= masterClipY - renderAreaY;
            renderAreaY = masterClipY;
        }
        int masterClipOutsideX = masterClipX + masterClipWidth;
        int masterClipOutsideY = masterClipY + masterClipHeight;
        if (renderAreaX >= masterClipOutsideX) {
            renderAreaWidth = 0;
            outside = true;
        } else {
            renderAreaWidth = Math.max(0, Math.min(renderAreaWidth, masterClipOutsideX - renderAreaX));
        }
        if (renderAreaY >= masterClipOutsideY) {
            renderAreaHeight = 0;
            outside = true;
        } else {
            renderAreaHeight = Math.max(0, Math.min(renderAreaHeight, masterClipOutsideY - renderAreaY));
        }
        if (!outside) {
            VGEngine.setMasterClip(new Rectangle(renderAreaX, renderAreaY, renderAreaWidth, renderAreaHeight));
        }
        return !outside;
    }

    public static void revert(MicroUIGraphicsContext g) {
        VGEngine.disableMasterClip();
    }
}

