/*
 * Decompiled with CFR 0.152.
 */
package ej.microvg.image.raw;

import ej.microui.display.MicroUIGraphicsContext;
import ej.microvg.image.raw.ImageElement;
import ej.microvg.paint.PaintVisitor;
import java.util.ArrayList;

public class GroupElement
implements ImageElement {
    final ArrayList<ImageElement> children = new ArrayList(0);

    public GroupElement() {
    }

    public GroupElement(GroupElement element, PaintVisitor transformer) {
        this();
        for (ImageElement imageElement : element.children) {
            this.children.add(imageElement.transform(transformer));
        }
    }

    public void addChild(ImageElement child) {
        this.children.add(child);
    }

    @Override
    public void draw(MicroUIGraphicsContext g, float[] matrix) {
        float[] localMatrix = this.updateMatrix(matrix, 0L, false);
        for (ImageElement child : this.children) {
            child.draw(g, localMatrix);
        }
    }

    @Override
    public void draw(MicroUIGraphicsContext g, float[] matrix, int alpha) {
        float[] localMatrix = this.updateMatrix(matrix, 0L, false);
        for (ImageElement child : this.children) {
            child.draw(g, localMatrix, alpha);
        }
    }

    @Override
    public void drawAnimated(MicroUIGraphicsContext g, float[] matrix, long elapsedTime) {
        float[] localMatrix = this.updateMatrix(matrix, elapsedTime, true);
        for (ImageElement child : this.children) {
            child.drawAnimated(g, localMatrix, elapsedTime);
        }
    }

    @Override
    public void drawAnimated(MicroUIGraphicsContext g, float[] matrix, int alpha, long elapsedTime) {
        float[] localMatrix = this.updateMatrix(matrix, elapsedTime, true);
        for (ImageElement child : this.children) {
            child.drawAnimated(g, localMatrix, alpha, elapsedTime);
        }
    }

    @Override
    public void drawTransformed(MicroUIGraphicsContext g, float[] matrix, PaintVisitor transformer) {
        float[] localMatrix = this.updateMatrix(matrix, 0L, false);
        for (ImageElement child : this.children) {
            child.drawTransformed(g, localMatrix, transformer);
        }
    }

    @Override
    public void drawTransformedAnimated(MicroUIGraphicsContext g, float[] matrix, long elapsedTime, PaintVisitor transformer) {
        float[] localMatrix = this.updateMatrix(matrix, elapsedTime, true);
        for (ImageElement child : this.children) {
            child.drawTransformedAnimated(g, localMatrix, elapsedTime, transformer);
        }
    }

    public float[] updateMatrix(float[] globalMatrix, long atTime, boolean applyAnimations) {
        return globalMatrix;
    }

    @Override
    public ImageElement transform(PaintVisitor transformer) {
        return new GroupElement(this, transformer);
    }
}

