/*
 * Decompiled with CFR 0.152.
 */
package ej.microvg.image.raw;

import ej.microui.display.MicroUIGraphicsContext;
import ej.microvg.LLVGEngine;
import ej.microvg.MatrixHelper;
import ej.microvg.image.raw.PathElement;
import ej.microvg.paint.OpacityVisitor;
import ej.microvg.paint.PaintVisitor;
import ej.microvg.paint.TransformationVisitor;
import ej.microvg.paint.VGPaint;
import java.awt.geom.GeneralPath;

public class GradientElement
extends PathElement {
    final VGPaint gradient;

    public GradientElement(GeneralPath path, int fillRule, VGPaint gradient) {
        super(path, fillRule);
        this.gradient = gradient;
    }

    public GradientElement(GradientElement element, PaintVisitor transformer) {
        super(element.path, element.fillRule);
        this.gradient = element.gradient.apply(transformer);
    }

    @Override
    public void draw(MicroUIGraphicsContext g, float[] matrix) {
        this.draw(g, this.path, matrix, this.gradient, 255);
    }

    @Override
    public void draw(MicroUIGraphicsContext g, float[] matrix, int alpha) {
        this.draw(g, this.path, matrix, this.gradient, alpha);
    }

    @Override
    public void drawAnimated(MicroUIGraphicsContext g, float[] matrix, long atTime) {
        this.draw(g, this.getPathAtTime(atTime), matrix, this.gradient, this.getAlphaAtTime(255, atTime));
    }

    @Override
    public void drawAnimated(MicroUIGraphicsContext g, float[] matrix, int alpha, long atTime) {
        this.draw(g, this.getPathAtTime(atTime), matrix, this.gradient, this.getAlphaAtTime(alpha, atTime));
    }

    @Override
    public void drawTransformed(MicroUIGraphicsContext g, float[] matrix, PaintVisitor transformer) {
        this.draw(g, this.path, matrix, this.gradient.apply(transformer), 255);
    }

    @Override
    public void drawTransformedAnimated(MicroUIGraphicsContext g, float[] matrix, long atTime, PaintVisitor transformer) {
        this.draw(g, this.getPathAtTime(atTime), matrix, this.gradient.apply(transformer), this.getAlphaAtTime(255, atTime));
    }

    private void draw(MicroUIGraphicsContext g, GeneralPath path, float[] matrix, VGPaint gradient, int alpha) {
        VGPaint p = gradient.apply(new TransformationVisitor(MatrixHelper.getAffineTransform(matrix, 0.0f, 0.0f)));
        p = p.apply(new OpacityVisitor(alpha));
        LLVGEngine.Instance.getVGDrawer(g).drawPath(g, path, 0.0f, 0.0f, matrix, this.fillRule, 1, p);
    }

    GeneralPath getPathAtTime(long atTime) {
        return this.path;
    }

    int getAlphaAtTime(int alpha, long atTime) {
        return alpha;
    }

    @Override
    public PathElement transform(PaintVisitor transformer) {
        return new GradientElement(this, transformer);
    }
}

