/*
 * Decompiled with CFR 0.152.
 */
package ej.microvg.image.raw;

import ej.microui.display.MicroUIGraphicsContext;
import ej.microvg.LLVGEngine;
import ej.microvg.image.raw.PathElement;
import ej.microvg.paint.PaintVisitor;
import ej.microvg.paint.VGColor;
import ej.microvg.paint.VGPaint;
import java.awt.geom.GeneralPath;

public class ColorElement
extends PathElement {
    final int color;

    public ColorElement(GeneralPath path, int fillRule, int color) {
        super(path, fillRule);
        this.color = color;
    }

    public ColorElement(ColorElement element, PaintVisitor transformer) {
        super(element.path, element.fillRule);
        this.color = transformer.visitColor(element.color);
    }

    @Override
    public void draw(MicroUIGraphicsContext g, float[] matrix) {
        this.drawWithColor(g, this.path, matrix, this.color);
    }

    @Override
    public void draw(MicroUIGraphicsContext g, float[] matrix, int alpha) {
        int colorWithAlpha = VGPaint.applyOpacity(this.color, alpha);
        this.drawWithColor(g, this.path, matrix, colorWithAlpha);
    }

    @Override
    public void drawAnimated(MicroUIGraphicsContext g, float[] matrix, long atTime) {
        int colorAtTime = this.getColorAtTime(atTime);
        this.drawWithColor(g, this.getPathAtTime(atTime), matrix, colorAtTime);
    }

    @Override
    public void drawAnimated(MicroUIGraphicsContext g, float[] matrix, int alpha, long atTime) {
        int colorAtTime = this.getColorAtTime(atTime);
        int colorWithAlpha = VGPaint.applyOpacity(colorAtTime, alpha);
        this.drawWithColor(g, this.getPathAtTime(atTime), matrix, colorWithAlpha);
    }

    @Override
    public void drawTransformed(MicroUIGraphicsContext g, float[] matrix, PaintVisitor transformer) {
        int transformedColor = transformer.visitColor(this.color);
        this.drawWithColor(g, this.path, matrix, transformedColor);
    }

    @Override
    public void drawTransformedAnimated(MicroUIGraphicsContext g, float[] matrix, long atTime, PaintVisitor transformer) {
        int colorAtTime = this.getColorAtTime(atTime);
        int transformedColor = transformer.visitColor(colorAtTime);
        this.drawWithColor(g, this.getPathAtTime(atTime), matrix, transformedColor);
    }

    private void drawWithColor(MicroUIGraphicsContext g, GeneralPath path, float[] matrix, int color) {
        VGColor c = new VGColor(color);
        LLVGEngine.Instance.getVGDrawer(g).drawPath(g, path, 0.0f, 0.0f, matrix, this.fillRule, 1, c);
    }

    int getColorAtTime(long atTime) {
        return this.color;
    }

    GeneralPath getPathAtTime(long atTime) {
        return this.path;
    }

    @Override
    public PathElement transform(PaintVisitor transformer) {
        return new ColorElement(this, transformer);
    }
}

