/*
 * Decompiled with CFR 0.152.
 */
package ej.microvg.image.raw;

import ej.microvg.image.ColorHelper;
import ej.microvg.image.raw.Animation;
import ej.microvg.image.raw.ArgbEvaluator;
import ej.microvg.image.raw.PathInterpolator;
import ej.microvg.paint.PaintVisitor;

public class ColorAnimation
extends Animation {
    private final int startColor;
    private final int endColor;

    public ColorAnimation(int begin, int duration, int keepDuration, PathInterpolator pathInterpolator, int startColor, int endColor) {
        super(begin, duration, keepDuration, pathInterpolator);
        this.startColor = startColor;
        this.endColor = endColor;
    }

    public ColorAnimation(ColorAnimation element, PaintVisitor transformer) {
        super(element.begin, element.duration, element.keepDuration, element.pathInterpolator);
        this.startColor = transformer.visitColor(element.startColor);
        this.endColor = transformer.visitColor(element.endColor);
    }

    public int updateColorAtTime(long atTime, int color) {
        int begin = this.begin;
        int duration = this.duration;
        int keepDuration = this.keepDuration;
        int startColor = this.startColor;
        int endColor = this.endColor;
        if (atTime >= (long)begin) {
            if (atTime < (long)(begin + duration)) {
                float transformRatio = this.getTransformRatioAtTime(atTime - (long)begin);
                return ArgbEvaluator.interpolateColor(transformRatio, startColor, endColor);
            }
            if (atTime < (long)(begin + duration + keepDuration) || -1 == keepDuration) {
                int red = ColorHelper.getRed(endColor);
                int green = ColorHelper.getGreen(endColor);
                int blue = ColorHelper.getBlue(endColor);
                return ColorHelper.getColor(0, red, green, blue);
            }
        }
        return color;
    }

    public ColorAnimation transform(PaintVisitor transformer) {
        int transformedStartColor = transformer.visitColor(ColorHelper.updateAlpha(this.startColor, (byte)-1)) & 0xFFFFFF;
        int transformedEndColor = transformer.visitColor(ColorHelper.updateAlpha(this.endColor, (byte)-1)) & 0xFFFFFF;
        return new ColorAnimation(this.begin, this.duration, this.keepDuration, this.pathInterpolator, transformedStartColor, transformedEndColor);
    }
}

