/*
 * Decompiled with CFR 0.152.
 */
package ej.microvg.image.raw;

public class ArgbEvaluator {
    private static final double GAMMA_VALUE = 2.2;

    private ArgbEvaluator() {
    }

    public static int interpolateColor(float fraction, int startColor, int endColor) {
        float startA = (float)(startColor >> 24 & 0xFF) / 255.0f;
        float startR = (float)(startColor >> 16 & 0xFF) / 255.0f;
        float startG = (float)(startColor >> 8 & 0xFF) / 255.0f;
        float startB = (float)(startColor & 0xFF) / 255.0f;
        float endA = (float)(endColor >> 24 & 0xFF) / 255.0f;
        float endR = (float)(endColor >> 16 & 0xFF) / 255.0f;
        float endG = (float)(endColor >> 8 & 0xFF) / 255.0f;
        float endB = (float)(endColor & 0xFF) / 255.0f;
        startR = (float)Math.pow(startR, 2.2);
        startG = (float)Math.pow(startG, 2.2);
        startB = (float)Math.pow(startB, 2.2);
        endR = (float)Math.pow(endR, 2.2);
        endG = (float)Math.pow(endG, 2.2);
        endB = (float)Math.pow(endB, 2.2);
        float a = startA + fraction * (endA - startA);
        float r = startR + fraction * (endR - startR);
        float g = startG + fraction * (endG - startG);
        float b = startB + fraction * (endB - startB);
        r = (float)Math.pow(r, 0.45454545454545453) * 255.0f;
        g = (float)Math.pow(g, 0.45454545454545453) * 255.0f;
        b = (float)Math.pow(b, 0.45454545454545453) * 255.0f;
        return Math.round(a *= 255.0f) << 24 | Math.round(r) << 16 | Math.round(g) << 8 | Math.round(b);
    }
}

