/*
 * Decompiled with CFR 0.152.
 */
package ej.microvg.image.raw;

import ej.microvg.MatrixHelper;
import ej.microvg.image.raw.GroupAnimation;
import ej.microvg.image.raw.GroupElement;
import ej.microvg.image.raw.ImageElement;
import ej.microvg.paint.PaintVisitor;

public class AnimatedGroupElement
extends GroupElement {
    final GroupAnimation[] scaleAnimations;
    final GroupAnimation[] rotateAnimations;
    final GroupAnimation[] translateAnimations;
    final float scaleX;
    final float scaleY;
    final float translateX;
    final float translateY;
    final float rotation;
    final float pivotX;
    final float pivotY;

    public AnimatedGroupElement(GroupAnimation[] scaleAnimations, GroupAnimation[] rotateAnimations, GroupAnimation[] translateAnimations, float scaleX, float scaleY, float translateX, float translateY, float rotation, float pivotX, float pivotY) {
        this.scaleAnimations = scaleAnimations;
        this.rotateAnimations = rotateAnimations;
        this.translateAnimations = translateAnimations;
        this.scaleX = scaleX;
        this.scaleY = scaleY;
        this.translateX = translateX;
        this.translateY = translateY;
        this.rotation = rotation;
        this.pivotX = pivotX;
        this.pivotY = pivotY;
    }

    private AnimatedGroupElement(AnimatedGroupElement element, PaintVisitor transformer) {
        super(element, transformer);
        this.scaleAnimations = element.scaleAnimations;
        this.rotateAnimations = element.rotateAnimations;
        this.translateAnimations = element.translateAnimations;
        this.scaleX = element.scaleX;
        this.scaleY = element.scaleY;
        this.translateX = element.translateX;
        this.translateY = element.translateY;
        this.rotation = element.rotation;
        this.pivotX = element.pivotX;
        this.pivotY = element.pivotY;
    }

    @Override
    public float[] updateMatrix(float[] globalMatrix, long atTime, boolean applyAnimations) {
        float[] matrix = MatrixHelper.create(globalMatrix);
        if (applyAnimations) {
            this.applyAnimation(matrix, atTime, this.translateAnimations);
        }
        this.preTranslate(matrix);
        if (applyAnimations) {
            this.applyAnimation(matrix, atTime, this.rotateAnimations);
        }
        this.preRotate(matrix);
        if (applyAnimations) {
            this.applyAnimation(matrix, atTime, this.scaleAnimations);
        }
        this.preScale(matrix);
        return matrix;
    }

    private void applyAnimation(float[] matrix, long atTime, GroupAnimation[] animations) {
        GroupAnimation[] groupAnimationArray = animations;
        int n = animations.length;
        int n2 = 0;
        while (n2 < n) {
            GroupAnimation animation = groupAnimationArray[n2];
            animation.updateMatrix(matrix, atTime);
            ++n2;
        }
    }

    private void preScale(float[] matrix) {
        float pivotX = this.pivotX;
        float pivotY = this.pivotY;
        MatrixHelper.translate(matrix, pivotX, pivotY);
        MatrixHelper.scale(matrix, this.scaleX, this.scaleY);
        MatrixHelper.translate(matrix, -pivotX, -pivotY);
    }

    private void preRotate(float[] matrix) {
        float pivotX = this.pivotX;
        float pivotY = this.pivotY;
        MatrixHelper.translate(matrix, pivotX, pivotY);
        MatrixHelper.rotate(matrix, this.rotation);
        MatrixHelper.translate(matrix, -pivotX, -pivotY);
    }

    private void preTranslate(float[] matrix) {
        float translateX = this.translateX;
        float translateY = this.translateY;
        if (0.0f != translateX || 0.0f != translateY) {
            MatrixHelper.translate(matrix, translateX, translateY);
        }
    }

    @Override
    public ImageElement transform(PaintVisitor transformer) {
        return new AnimatedGroupElement(this, transformer);
    }
}

