/*
 * Decompiled with CFR 0.152.
 */
package ej.microvg.image.raw;

import ej.microvg.image.raw.AlphaAnimation;
import ej.microvg.image.raw.GradientElement;
import ej.microvg.image.raw.PathDataAnimation;
import ej.microvg.image.raw.PathElement;
import ej.microvg.paint.PaintVisitor;
import ej.microvg.paint.VGPaint;
import java.awt.geom.GeneralPath;

public class AnimatedGradientElement
extends GradientElement {
    private final AlphaAnimation[] alphasAnimations;
    private final PathDataAnimation[] pathDataAnimations;

    public AnimatedGradientElement(GeneralPath path, int fillRule, VGPaint gradient, AlphaAnimation[] alphasAnimations, PathDataAnimation[] pathDataAnimations) {
        super(path, fillRule, gradient);
        this.alphasAnimations = alphasAnimations;
        this.pathDataAnimations = pathDataAnimations;
    }

    private AnimatedGradientElement(AnimatedGradientElement element, PaintVisitor transformer) {
        super(element, transformer);
        this.alphasAnimations = element.alphasAnimations;
        this.pathDataAnimations = element.pathDataAnimations;
    }

    @Override
    int getAlphaAtTime(int alpha, long atTime) {
        if (this.alphasAnimations.length > 0) {
            AlphaAnimation[] alphaAnimations;
            byte animAlpha = -1;
            AlphaAnimation[] alphaAnimationArray = alphaAnimations = this.alphasAnimations;
            int n = alphaAnimations.length;
            int n2 = 0;
            while (n2 < n) {
                AlphaAnimation alphaAnimation = alphaAnimationArray[n2];
                animAlpha = alphaAnimation.updateAlphaAtTime(atTime, animAlpha);
                ++n2;
            }
            return Byte.toUnsignedInt(animAlpha) * alpha / 255;
        }
        return alpha;
    }

    @Override
    public GeneralPath getPathAtTime(long atTime) {
        PathDataAnimation[] pathDataAnimations;
        GeneralPath pathToDraw = this.path;
        PathDataAnimation[] pathDataAnimationArray = pathDataAnimations = this.pathDataAnimations;
        int n = pathDataAnimations.length;
        int n2 = 0;
        while (n2 < n) {
            PathDataAnimation pathDataAnimation = pathDataAnimationArray[n2];
            pathToDraw = pathDataAnimation.updatePathAtTime(atTime, pathToDraw);
            ++n2;
        }
        return pathToDraw;
    }

    @Override
    public PathElement transform(PaintVisitor transformer) {
        return new AnimatedGradientElement(this, transformer);
    }
}

