/*
 * Decompiled with CFR 0.152.
 */
package ej.microvg.image.raw;

import ej.microvg.image.ColorHelper;
import ej.microvg.image.raw.AlphaAnimation;
import ej.microvg.image.raw.ColorAnimation;
import ej.microvg.image.raw.ColorElement;
import ej.microvg.image.raw.PathDataAnimation;
import ej.microvg.image.raw.PathElement;
import ej.microvg.paint.PaintVisitor;
import java.awt.geom.GeneralPath;

public class AnimatedColorElement
extends ColorElement {
    private final ColorAnimation[] colorAnimations;
    private final AlphaAnimation[] alphaAnimations;
    private final PathDataAnimation[] pathDataAnimations;

    public AnimatedColorElement(GeneralPath path, int fillRule, int color, ColorAnimation[] colorAnimations, AlphaAnimation[] alphaAnimations, PathDataAnimation[] pathDataAnimations) {
        super(path, fillRule, color);
        this.colorAnimations = colorAnimations;
        this.alphaAnimations = alphaAnimations;
        this.pathDataAnimations = pathDataAnimations;
    }

    private AnimatedColorElement(AnimatedColorElement element, PaintVisitor transformer) {
        super(element, transformer);
        ColorAnimation[] elementColorAnimations = element.colorAnimations;
        int colorAnimationsLength = elementColorAnimations.length;
        this.colorAnimations = new ColorAnimation[colorAnimationsLength];
        int i = 0;
        while (i < colorAnimationsLength) {
            ColorAnimation colorAnimation = elementColorAnimations[i];
            assert (colorAnimation != null);
            this.colorAnimations[i] = new ColorAnimation(colorAnimation, transformer);
            ++i;
        }
        AlphaAnimation[] elementAlphaAnimations = element.alphaAnimations;
        int alphaAnimationsLength = elementAlphaAnimations.length;
        this.alphaAnimations = new AlphaAnimation[alphaAnimationsLength];
        int i2 = 0;
        while (i2 < alphaAnimationsLength) {
            AlphaAnimation alphaAnimation = elementAlphaAnimations[i2];
            assert (alphaAnimation != null);
            this.alphaAnimations[i2] = new AlphaAnimation(alphaAnimation, transformer);
            ++i2;
        }
        this.pathDataAnimations = element.pathDataAnimations;
    }

    @Override
    public int getColorAtTime(long atTime) {
        AlphaAnimation[] alphaAnimations;
        ColorAnimation[] colorAnimations;
        int currentColor = this.color;
        byte alpha = (byte)ColorHelper.getAlpha(currentColor);
        ColorAnimation[] colorAnimationArray = colorAnimations = this.colorAnimations;
        int n = colorAnimations.length;
        int n2 = 0;
        while (n2 < n) {
            ColorAnimation colorAnimation = colorAnimationArray[n2];
            currentColor = colorAnimation.updateColorAtTime(atTime, currentColor);
            ++n2;
        }
        AlphaAnimation[] alphaAnimationArray = alphaAnimations = this.alphaAnimations;
        int n3 = alphaAnimations.length;
        n = 0;
        while (n < n3) {
            AlphaAnimation alphaAnimation = alphaAnimationArray[n];
            alpha = alphaAnimation.updateAlphaAtTime(atTime, alpha);
            ++n;
        }
        return ColorHelper.updateAlpha(currentColor, alpha);
    }

    @Override
    public GeneralPath getPathAtTime(long atTime) {
        PathDataAnimation[] pathDataAnimations;
        GeneralPath pathToDraw = this.path;
        PathDataAnimation[] pathDataAnimationArray = pathDataAnimations = this.pathDataAnimations;
        int n = pathDataAnimations.length;
        int n2 = 0;
        while (n2 < n) {
            PathDataAnimation pathDataAnimation = pathDataAnimationArray[n2];
            pathToDraw = pathDataAnimation.updatePathAtTime(atTime, pathToDraw);
            ++n2;
        }
        return pathToDraw;
    }

    @Override
    public PathElement transform(PaintVisitor transformer) {
        return new AnimatedColorElement(this, transformer);
    }
}

