/*
 * Decompiled with CFR 0.152.
 */
package ej.microvg.image.raw;

import ej.microvg.image.ColorHelper;
import ej.microvg.image.raw.Animation;
import ej.microvg.image.raw.PathInterpolator;
import ej.microvg.paint.PaintVisitor;

public class AlphaAnimation
extends Animation {
    private final byte startAlpha;
    private final byte endAlpha;

    public AlphaAnimation(int begin, int duration, int keepDuration, PathInterpolator pathInterpolator, byte startAlpha, byte endAlpha) {
        super(begin, duration, keepDuration, pathInterpolator);
        this.startAlpha = startAlpha;
        this.endAlpha = endAlpha;
    }

    public AlphaAnimation(AlphaAnimation element, PaintVisitor transformer) {
        super(element.begin, element.duration, element.keepDuration, element.pathInterpolator);
        this.startAlpha = (byte)(transformer.visitColor(element.startAlpha << 24) >>> 24);
        this.endAlpha = (byte)(transformer.visitColor(element.endAlpha << 24) >>> 24);
    }

    public byte updateAlphaAtTime(long atTime, byte alpha) {
        int begin = this.begin;
        int duration = this.duration;
        int keepDuration = this.keepDuration;
        byte startAlpha = this.startAlpha;
        byte endAlpha = this.endAlpha;
        if (atTime >= (long)begin) {
            if (atTime < (long)(begin + duration)) {
                float transformRatio = this.getTransformRatioAtTime(atTime - (long)begin);
                return (byte)(transformRatio * (float)(0xFF & endAlpha) + (1.0f - transformRatio) * (float)(0xFF & startAlpha));
            }
            if (atTime < (long)(begin + duration + keepDuration) || -1 == keepDuration) {
                return endAlpha;
            }
        }
        return alpha;
    }

    public AlphaAnimation transform(PaintVisitor transformer) {
        byte transformedStartAlpha = (byte)ColorHelper.getAlpha(transformer.visitColor(ColorHelper.updateAlpha(0, this.startAlpha)));
        byte transformedEndAlpha = (byte)ColorHelper.getAlpha(transformer.visitColor(ColorHelper.updateAlpha(0, this.endAlpha)));
        return new AlphaAnimation(this.begin, this.duration, this.keepDuration, this.pathInterpolator, transformedStartAlpha, transformedEndAlpha);
    }
}

