/*
 * Decompiled with CFR 0.152.
 */
package ej.microvg.image.bvi;

import ej.microvg.image.bvi.Element;
import ej.microvg.paint.OpacityVisitor;
import ej.microvg.paint.PaintVisitor;
import ej.microvg.paint.VGColor;
import ej.microvg.paint.VGPaint;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;

public class ShapeElement
extends Element {
    private final Shape shape;
    private final Stroke stroke;
    private final boolean fill;

    public ShapeElement(Shape shape, int color, Stroke stroke, boolean fill, boolean antialias, Rectangle clip) {
        super(new VGColor(color), antialias, new AffineTransform(), clip);
        this.shape = shape;
        this.stroke = stroke;
        this.fill = fill;
    }

    private ShapeElement(ShapeElement element, VGPaint color, AffineTransform matrix, Rectangle clip) {
        super(element, color, matrix, clip);
        this.shape = element.shape;
        this.stroke = element.stroke;
        this.fill = element.fill;
    }

    @Override
    void render(Graphics2D gc, AffineTransform at) {
        Shape shape = at.createTransformedShape(this.shape);
        Stroke stroke = this.stroke;
        Stroke originalStroke = gc.getStroke();
        if (stroke != null) {
            gc.setStroke(stroke);
        }
        if (this.fill) {
            gc.fill(shape);
        } else {
            gc.draw(shape);
        }
        if (stroke != null) {
            gc.setStroke(originalStroke);
        }
    }

    @Override
    public ShapeElement derive(AffineTransform at, int alpha, PaintVisitor colorTransformer, Rectangle clip) {
        VGPaint paint = this.getPaintHolder().apply(colorTransformer);
        paint = paint.apply(new OpacityVisitor(alpha));
        return new ShapeElement(this, paint, at, clip);
    }
}

