/*
 * Decompiled with CFR 0.152.
 */
package ej.microvg.image.bvi;

import ej.microvg.image.bvi.Element;
import ej.microvg.paint.OpacityVisitor;
import ej.microvg.paint.PaintVisitor;
import ej.microvg.paint.TransformationVisitor;
import ej.microvg.paint.VGPaint;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;

public class PathElement
extends Element {
    private final GeneralPath path;
    private final Composite blend;

    public PathElement(GeneralPath path, VGPaint paint, Composite blend, AffineTransform matrix, Rectangle clip) {
        super(paint, true, matrix, clip);
        this.path = path;
        this.blend = blend;
    }

    private PathElement(PathElement element, VGPaint color, AffineTransform matrix, Rectangle clip) {
        super(element, color, matrix, clip);
        this.path = element.path;
        this.blend = element.blend;
    }

    @Override
    void render(Graphics2D g2d, AffineTransform at) {
        Composite originalComposite = g2d.getComposite();
        g2d.setComposite(this.blend);
        Shape shape = at.createTransformedShape(this.path);
        g2d.fill(shape);
        g2d.setComposite(originalComposite);
    }

    @Override
    public Element derive(AffineTransform at, int alpha, PaintVisitor colorTransformer, Rectangle clip) {
        VGPaint paint = this.getPaintHolder().apply(colorTransformer);
        paint = paint.apply(new OpacityVisitor(alpha));
        paint = paint.apply(new TransformationVisitor(at));
        return new PathElement(this, paint, at, clip);
    }
}

