/*
 * Decompiled with CFR 0.152.
 */
package ej.microvg.image.bvi;

import ej.microui.display.MicroUIGraphicsContext;
import ej.microvg.Util;
import ej.microvg.paint.OpacityVisitor;
import ej.microvg.paint.PaintVisitor;
import ej.microvg.paint.TransformationVisitor;
import ej.microvg.paint.VGPaint;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;

public abstract class Element {
    private final AffineTransform matrix;
    private final Rectangle clip;
    private final VGPaint paint;
    private final RenderingHints rh;

    public Element(VGPaint paint, boolean antialias, AffineTransform matrix, Rectangle clip) {
        this.clip = clip;
        this.matrix = matrix;
        this.paint = paint;
        this.rh = new RenderingHints(RenderingHints.KEY_ANTIALIASING, antialias ? RenderingHints.VALUE_ANTIALIAS_ON : RenderingHints.VALUE_ANTIALIAS_OFF);
    }

    Element(Element element, VGPaint paint, AffineTransform matrix, Rectangle clip) {
        this.matrix = (AffineTransform)element.matrix.clone();
        this.matrix.preConcatenate(matrix);
        this.clip = clip.intersection(matrix.createTransformedShape(element.clip).getBounds());
        this.paint = paint;
        this.rh = element.rh;
    }

    public void render(MicroUIGraphicsContext target, Graphics2D gc2d, AffineTransform transformation, int alpha, PaintVisitor transformer) {
        Util.setClip(gc2d, target, this.clip, transformation);
        AffineTransform matrix = (AffineTransform)this.matrix.clone();
        matrix.preConcatenate(transformation);
        VGPaint paint = this.paint.apply(transformer);
        paint = paint.apply(new TransformationVisitor(transformation));
        paint = paint.apply(new OpacityVisitor(alpha));
        gc2d.setPaint(paint.getPaint());
        gc2d.setRenderingHints(this.rh);
        this.render(gc2d, matrix);
    }

    abstract void render(Graphics2D var1, AffineTransform var2);

    public AffineTransform getMatrix() {
        return this.matrix;
    }

    public VGPaint getPaintHolder() {
        return this.paint;
    }

    public Rectangle getClip() {
        return this.clip;
    }

    public abstract Element derive(AffineTransform var1, int var2, PaintVisitor var3, Rectangle var4);
}

