/*
 * Decompiled with CFR 0.152.
 */
package ej.microvg.image.bvi;

import ej.drawing.LLDWPainter;
import ej.microui.display.MicroUIGraphicsContext;
import ej.microvg.LLVGEngine;
import ej.microvg.MatrixHelper;
import ej.microvg.Util;
import ej.microvg.bvi.BufferedVectorImageDrawer;
import ej.microvg.image.bvi.BufferedVectorImage;
import ej.microvg.image.bvi.PathElement;
import ej.microvg.image.bvi.ShapeElement;
import ej.microvg.paint.TransformationVisitor;
import ej.microvg.paint.VGPaint;
import java.awt.BasicStroke;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.RoundRectangle2D;

public class BufferedVectorImageDrawerFull
extends BufferedVectorImageDrawer {
    public void drawLine(MicroUIGraphicsContext gc, int x1, int y1, int x2, int y2) {
        this.drawShape(gc, (Shape)new Line2D.Double(x1, y1, (double)x2 - 1.0, (double)y2 - 1.0), false);
    }

    public void drawHorizontalLine(MicroUIGraphicsContext gc, int x1, int x2, int y) {
        this.drawShape(gc, (Shape)new Rectangle(x1, y, x2 - x1 + 1, 1), true);
    }

    public void drawVerticalLine(MicroUIGraphicsContext gc, int x, int y1, int y2) {
        this.drawShape(gc, (Shape)new Rectangle(x, y1, 1, y2 - y1 + 1), true);
    }

    public void fillRectangle(MicroUIGraphicsContext gc, int x1, int y1, int x2, int y2) {
        this.drawShape(gc, (Shape)new Rectangle(x1, y1, x2 - x1 + 1, y2 - y1 + 1), true);
    }

    public void drawRoundedRectangle(MicroUIGraphicsContext gc, int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.drawShape(gc, (Shape)new RoundRectangle2D.Double(x, y, (double)width - 1.0, (double)height - 1.0, arcWidth, arcHeight), false);
    }

    public void fillRoundedRectangle(MicroUIGraphicsContext gc, int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.drawShape(gc, (Shape)new RoundRectangle2D.Double(BufferedVectorImageDrawerFull.getCoordToFillAShape(x), BufferedVectorImageDrawerFull.getCoordToFillAShape(y), width, height, arcWidth, arcHeight), true);
    }

    public void drawCircleArc(MicroUIGraphicsContext gc, int x, int y, int diameter, float startAngle, float arcAngle) {
        this.drawShape(gc, (Shape)new Arc2D.Double(x, y, (double)diameter - 1.0, (double)diameter - 1.0, startAngle, arcAngle, 0), false);
    }

    public void fillCircleArc(MicroUIGraphicsContext gc, int x, int y, int diameter, float startAngle, float arcAngle) {
        this.drawShape(gc, (Shape)new Arc2D.Double(BufferedVectorImageDrawerFull.getCoordToFillAShape(x), BufferedVectorImageDrawerFull.getCoordToFillAShape(y), diameter, diameter, startAngle, arcAngle, 2), true);
    }

    public void drawEllipseArc(MicroUIGraphicsContext gc, int x, int y, int width, int height, float startAngle, float arcAngle) {
        this.drawShape(gc, (Shape)new Arc2D.Double(x, y, (double)width - 1.0, (double)height - 1.0, startAngle, arcAngle, 0), false);
    }

    public void fillEllipseArc(MicroUIGraphicsContext gc, int x, int y, int width, int height, float startAngle, float arcAngle) {
        this.drawShape(gc, (Shape)new Arc2D.Double(BufferedVectorImageDrawerFull.getCoordToFillAShape(x), BufferedVectorImageDrawerFull.getCoordToFillAShape(y), width, height, startAngle, arcAngle, 2), true);
    }

    public void drawCircle(MicroUIGraphicsContext gc, int x, int y, int diameter) {
        this.drawShape(gc, (Shape)new Ellipse2D.Double(x, y, (double)diameter - 1.0, (double)diameter - 1.0), false);
    }

    public void fillCircle(MicroUIGraphicsContext gc, int x, int y, int diameter) {
        this.drawShape(gc, (Shape)new Ellipse2D.Double(BufferedVectorImageDrawerFull.getCoordToFillAShape(x), BufferedVectorImageDrawerFull.getCoordToFillAShape(y), diameter, diameter), true);
    }

    public void drawEllipse(MicroUIGraphicsContext gc, int x, int y, int width, int height) {
        this.drawShape(gc, (Shape)new Ellipse2D.Double(x, y, (double)width - 1.0, (double)height - 1.0), false);
    }

    public void fillEllipse(MicroUIGraphicsContext gc, int x, int y, int width, int height) {
        this.drawShape(gc, (Shape)new Ellipse2D.Double(BufferedVectorImageDrawerFull.getCoordToFillAShape(x), BufferedVectorImageDrawerFull.getCoordToFillAShape(y), width, height), true);
    }

    public void drawThickFadedPoint(MicroUIGraphicsContext gc, int x, int y, int thickness, int fade) {
        int diameter = BufferedVectorImageDrawerFull.getThickness(thickness, fade);
        this.drawShape(gc, new Ellipse2D.Double((double)x - (double)diameter / 2.0, (double)y - (double)diameter / 2.0, diameter, diameter), 1, true, true);
    }

    public void drawThickFadedLine(MicroUIGraphicsContext gc, int x1, int y1, int x2, int y2, int thickness, int fade, LLDWPainter.DrawingCap start, LLDWPainter.DrawingCap end) {
        this.drawShape(gc, new Line2D.Double(x1, y1, x2, y2), thickness, fade, start, end, 0);
    }

    public void drawThickFadedCircle(MicroUIGraphicsContext gc, int x, int y, int diameter, int thickness, int fade) {
        this.drawShape(gc, new Ellipse2D.Double(x, y, (double)diameter - 1.0, (double)diameter - 1.0), BufferedVectorImageDrawerFull.getThickness(thickness, fade), true, false);
    }

    public void drawThickFadedCircleArc(MicroUIGraphicsContext gc, int x, int y, int diameter, float startAngle, float arcAngle, int thickness, int fade, LLDWPainter.DrawingCap start, LLDWPainter.DrawingCap end) {
        int endCapIndex = (int)((arcAngle + 89.0f) / 90.0f);
        this.drawShape(gc, new Arc2D.Double(x, y, (double)diameter - 1.0, (double)diameter - 1.0, startAngle, arcAngle, 0), thickness, fade, start, end, endCapIndex);
    }

    public void drawThickFadedEllipse(MicroUIGraphicsContext gc, int x, int y, int width, int height, int thickness, int fade) {
        this.drawShape(gc, new Ellipse2D.Double(x, y, (double)width - 1.0, (double)height - 1.0), BufferedVectorImageDrawerFull.getThickness(thickness, fade), true, false);
    }

    public void drawThickLine(MicroUIGraphicsContext gc, int x1, int y1, int x2, int y2, int thickness) {
        this.drawShape(gc, (Shape)new Line2D.Double(x1, y1, x2, y2), thickness);
    }

    public void drawThickCircle(MicroUIGraphicsContext gc, int x, int y, int diameter, int thickness) {
        this.drawShape(gc, (Shape)new Ellipse2D.Double(x, y, (double)diameter - 1.0, (double)diameter - 1.0), thickness);
    }

    public void drawThickEllipse(MicroUIGraphicsContext gc, int x, int y, int width, int height, int thickness) {
        this.drawShape(gc, (Shape)new Ellipse2D.Double(x, y, (double)width - 1.0, (double)height - 1.0), thickness);
    }

    public void drawThickCircleArc(MicroUIGraphicsContext gc, int x, int y, int diameter, float startAngle, float arcAngle, int thickness) {
        this.drawShape(gc, (Shape)new Arc2D.Double(x, y, (double)diameter - 1.0, (double)diameter - 1.0, startAngle, arcAngle, 0), thickness);
    }

    @Override
    public void drawPath(MicroUIGraphicsContext gc, GeneralPath path, float x, float y, float[] matrix, int fillRule, int blend, VGPaint paint) {
        LLVGEngine engine = LLVGEngine.Instance;
        path.setWindingRule(engine.getFillRule(fillRule));
        AffineTransform translatedTransform = new AffineTransform();
        translatedTransform.translate(x, y);
        translatedTransform.concatenate(MatrixHelper.getAffineTransform(matrix, 0.0f, 0.0f));
        AffineTransform gradientMatrix = new AffineTransform();
        gradientMatrix.translate(x, y);
        this.getDestination(gc).addElement(new PathElement(path, paint.apply(new TransformationVisitor(gradientMatrix)), engine.getComposite(blend), translatedTransform, Util.getGraphicsContextClip(gc)));
    }

    private BufferedVectorImage getDestination(MicroUIGraphicsContext gc) {
        return (BufferedVectorImage)gc.getImage().getRAWImage();
    }

    private static int getThickness(int thickness, int fade) {
        return thickness + fade;
    }

    private static double getCoordToFillAShape(int coord) {
        double ret = coord;
        return ret - 0.5;
    }

    private void drawShape(MicroUIGraphicsContext gc, Shape shape, boolean fill) {
        this.getDestination(gc).addElement(new ShapeElement(shape, gc.getMicroUIColor(), null, fill, false, Util.getGraphicsContextClip(gc)));
    }

    private void drawShape(MicroUIGraphicsContext gc, Shape shape, int thickness) {
        this.getDestination(gc).addElement(new ShapeElement(shape, gc.getMicroUIColor(), new BasicStroke(thickness), false, false, Util.getGraphicsContextClip(gc)));
    }

    private void drawShape(MicroUIGraphicsContext gc, Shape shape, int thickness, boolean antialias, boolean fill) {
        this.getDestination(gc).addElement(new ShapeElement(shape, gc.getMicroUIColor(), new BasicStroke(thickness), fill, antialias, Util.getGraphicsContextClip(gc)));
    }

    private void drawShape(MicroUIGraphicsContext gc, Shape shape, int thickness, int fade, LLDWPainter.DrawingCap start, LLDWPainter.DrawingCap end, int endCapIndex) {
        Stroke stroke;
        int capStart = BufferedVectorImageDrawerFull.getCap(start);
        int capEnd = BufferedVectorImageDrawerFull.getCap(end);
        thickness = BufferedVectorImageDrawerFull.getThickness(thickness, fade);
        if (capStart != capEnd) {
            stroke = new BasicStroke(thickness, BufferedVectorImageDrawerFull.getCap(LLDWPainter.DrawingCap.DRAWING_ENDOFLINE_ROUNDED), 2);
            shape = stroke.createStrokedShape(shape);
            GeneralPath newshape = new GeneralPath();
            float[] coords = new float[6];
            int cubicCounter = 0;
            PathIterator i = shape.getPathIterator(null);
            while (!i.isDone()) {
                int type = i.currentSegment(coords);
                switch (type) {
                    case 0: {
                        newshape.moveTo(coords[0], coords[1]);
                        break;
                    }
                    case 1: {
                        newshape.lineTo(coords[0], coords[1]);
                        break;
                    }
                    case 2: {
                        newshape.quadTo(coords[0], coords[1], coords[2], coords[3]);
                        break;
                    }
                    case 3: {
                        BufferedVectorImageDrawerFull.manageCap(cubicCounter, newshape, coords, endCapIndex, start, end);
                        ++cubicCounter;
                        break;
                    }
                    default: {
                        newshape.closePath();
                    }
                }
                i.next();
            }
            stroke = new Stroke(){

                @Override
                public Shape createStrokedShape(Shape s) {
                    return s;
                }
            };
            shape = stroke.createStrokedShape(newshape);
        } else {
            stroke = new BasicStroke(thickness, capEnd, 2);
        }
        this.getDestination(gc).addElement(new ShapeElement(shape, gc.getMicroUIColor(), stroke, false, true, Util.getGraphicsContextClip(gc)));
    }

    private static void manageCap(int cubicCounter, GeneralPath newshape, float[] coords, int endCapIndex, LLDWPainter.DrawingCap startCap, LLDWPainter.DrawingCap endCap) {
        if (cubicCounter == endCapIndex) {
            BufferedVectorImageDrawerFull.crop(newshape, coords, endCap, true);
        } else if (cubicCounter == endCapIndex + 1) {
            BufferedVectorImageDrawerFull.crop(newshape, coords, endCap, false);
        } else if (cubicCounter == endCapIndex * 2 + 2) {
            BufferedVectorImageDrawerFull.crop(newshape, coords, startCap, true);
        } else if (cubicCounter == endCapIndex * 2 + 3) {
            BufferedVectorImageDrawerFull.crop(newshape, coords, startCap, false);
        } else {
            BufferedVectorImageDrawerFull.keepCubicTo(newshape, coords);
        }
    }

    private static void crop(GeneralPath newshape, float[] coords, LLDWPainter.DrawingCap cap, boolean firstCapPart) {
        if (LLDWPainter.DrawingCap.DRAWING_ENDOFLINE_ROUNDED == cap) {
            BufferedVectorImageDrawerFull.keepCubicTo(newshape, coords);
        } else if (!firstCapPart) {
            newshape.lineTo(coords[4], coords[5]);
        }
    }

    private static void keepCubicTo(GeneralPath newshape, float[] coords) {
        newshape.curveTo(coords[0], coords[1], coords[2], coords[3], coords[4], coords[5]);
    }

    private static int getCap(LLDWPainter.DrawingCap cap) {
        switch (cap) {
            default: {
                return 0;
            }
            case DRAWING_ENDOFLINE_ROUNDED: 
        }
        return 1;
    }
}

