/*
 * Decompiled with CFR 0.152.
 */
package ej.microvg.image.bvi;

import ej.microui.display.LLUIDisplay;
import ej.microui.display.MicroUIGraphicsContext;
import ej.microui.display.MicroUIImageFormat;
import ej.microvg.LLVGEngine;
import ej.microvg.MatrixHelper;
import ej.microvg.MicroVGImage;
import ej.microvg.Util;
import ej.microvg.image.ColorMatrixVisitor;
import ej.microvg.image.bvi.Element;
import ej.microvg.paint.PaintVisitor;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;

public class BufferedVectorImage
implements MicroVGImage {
    private List<Element> pipelineElements;

    public BufferedVectorImage() {
        this.clear();
    }

    public static boolean isVectorImageFormat(MicroUIGraphicsContext gc) {
        return BufferedVectorImage.isVectorImageFormat(gc.getFormat());
    }

    public static boolean isVectorImageFormat(MicroUIImageFormat format) {
        return LLVGEngine.BUFFERED_VECTOR_IMAGE_FORMAT == format;
    }

    public void clear() {
        this.pipelineElements = new ArrayList<Element>(0);
    }

    public void addElement(Element element) {
        this.pipelineElements.add(element);
    }

    private void draw(MicroUIGraphicsContext target, AffineTransform transformation, int alpha, PaintVisitor colorTransformer) {
        BufferedImage image = (BufferedImage)target.getImage().getRAWImage();
        Graphics2D gc2d = image.createGraphics();
        List<Element> p = this.pipelineElements;
        if (alpha > 0 && !p.isEmpty()) {
            Rectangle drawingArea = new Rectangle(-1, -1);
            for (Element element : p) {
                element.render(target, gc2d, transformation, alpha, colorTransformer);
                drawingArea = drawingArea.union(gc2d.getClipBounds());
            }
            if (!drawingArea.isEmpty()) {
                LLVGEngine.Instance.convertColorToColorToDraw(target, drawingArea);
            }
        }
    }

    private void draw(BufferedVectorImage target, AffineTransform transformation, int alpha, PaintVisitor colorTransformer, Rectangle clip) {
        List<Element> p = this.pipelineElements;
        if (alpha > 0 && !p.isEmpty()) {
            for (Element element : p) {
                target.addElement(element.derive(transformation, alpha, colorTransformer, clip));
            }
        }
    }

    @Override
    public int draw(MicroUIGraphicsContext gc, float[] matrix, int alpha, long elapsedTime, float[] colorMatrix) {
        PaintVisitor colorTransformer;
        AffineTransform at = MatrixHelper.getAffineTransform(matrix, 0.0f, 0.0f);
        PaintVisitor paintVisitor = colorTransformer = colorMatrix == null ? new PaintVisitor(){} : new ColorMatrixVisitor(colorMatrix);
        if (LLUIDisplay.Instance.isDisplayFormat(gc.getFormat())) {
            this.draw(gc, at, alpha, colorTransformer);
        } else if (BufferedVectorImage.isVectorImageFormat(gc)) {
            BufferedVectorImage vgDest = (BufferedVectorImage)gc.getImage().getRAWImage();
            this.draw(vgDest, at, alpha, colorTransformer, Util.getGraphicsContextClip(gc));
        }
        return 0;
    }

    @Override
    public MicroVGImage transform(PaintVisitor transformer) {
        return this;
    }
}

