/*
 * Decompiled with CFR 0.152.
 */
package ej.microvg.image;

import com.is2t.hil.HIL;
import ej.microvg.image.raw.RawImage;
import java.lang.ref.SoftReference;

public class RawImageHolder {
    private SoftReference<RawImage> reference;
    private final String path;
    private final byte[] sniContext;
    private final int[] metadata;

    public RawImageHolder(String path, byte[] sniContext, int[] metadata, RawImage image) {
        this.path = path;
        this.reference = new SoftReference<RawImage>(image);
        int l = sniContext.length;
        this.sniContext = new byte[l];
        System.arraycopy(sniContext, 0, this.sniContext, 0, l);
        l = metadata.length;
        this.metadata = new int[l];
        System.arraycopy(metadata, 0, this.metadata, 0, l);
    }

    public boolean isSameResource(String path) {
        return path.equals(this.path);
    }

    public void duplicate(byte[] sniContext, int[] metadata) {
        System.arraycopy(this.sniContext, 0, sniContext, 0, sniContext.length);
        System.arraycopy(this.metadata, 0, metadata, 0, metadata.length);
    }

    public RawImage getRAWImage() {
        RawImage ret = this.reference.get();
        if (ret == null) {
            byte[] data = HIL.getInstance().getResourceContent(this.path);
            ret = RawImage.createRawImage(data, null);
            this.reference = new SoftReference<RawImage>(ret);
        }
        return ret;
    }
}

