/*
 * Decompiled with CFR 0.152.
 */
package ej.microvg.image;

import ej.microvg.Util;
import ej.microvg.image.ColorHelper;
import ej.microvg.paint.PaintVisitor;

public class ColorMatrixVisitor
implements PaintVisitor {
    private static final int COLOR_MATRIX_WIDTH = 5;
    private static final int RED_OFFSET = 0;
    private static final int GREEN_OFFSET = 1;
    private static final int BLUE_OFFSET = 2;
    private static final int ALPHA_OFFSET = 3;
    private static final int CONSTANT_OFFSET = 4;
    private static final int RED_LINE = 0;
    private static final int GREEN_LINE = 5;
    private static final int BLUE_LINE = 10;
    private static final int ALPHA_LINE = 15;
    private final float[] colorMatrix;

    public ColorMatrixVisitor(float[] colorMatrix) {
        this.colorMatrix = colorMatrix;
    }

    @Override
    public int visitColor(int color) {
        int red = ColorHelper.getRed(color);
        int green = ColorHelper.getGreen(color);
        int blue = ColorHelper.getBlue(color);
        int alpha = ColorHelper.getAlpha(color);
        float[] colorMatrix = this.colorMatrix;
        int resultRed = this.computeComponent(red, green, blue, alpha, colorMatrix, 0);
        int resultGreen = this.computeComponent(red, green, blue, alpha, colorMatrix, 5);
        int resultBlue = this.computeComponent(red, green, blue, alpha, colorMatrix, 10);
        int resultAlpha = this.computeComponent(red, green, blue, alpha, colorMatrix, 15);
        return ColorHelper.getColor(resultAlpha, resultRed, resultGreen, resultBlue);
    }

    private int computeComponent(int red, int green, int blue, int alpha, float[] colorMatrix, int startIndex) {
        float redFactor = colorMatrix[startIndex + 0] * (float)red;
        float greenFactor = colorMatrix[startIndex + 1] * (float)green;
        float blueFactor = colorMatrix[startIndex + 2] * (float)blue;
        float alphaFactor = colorMatrix[startIndex + 3] * (float)alpha;
        float hardcodedColor = colorMatrix[startIndex + 4];
        return Util.limit((int)(redFactor + greenFactor + blueFactor + alphaFactor + hardcodedColor), 0, 255);
    }
}

