/*
 * Decompiled with CFR 0.152.
 */
package ej.microvg.image;

public class ColorHelper {
    public static final int MAX_COLOR_COMPONENT_VALUE = 255;
    public static final int ALPHA_SHIFT = 24;
    public static final int RED_SHIFT = 16;
    public static final int GREEN_SHIFT = 8;
    public static final int BLUE_SHIFT = 0;
    private static final int ALPHA_MASK = -16777216;
    private static final int RED_MASK = 0xFF0000;
    private static final int GREEN_MASK = 65280;
    private static final int BLUE_MASK = 255;

    private ColorHelper() {
    }

    public static int getAlpha(int color) {
        return (color & 0xFF000000) >>> 24;
    }

    public static int getRed(int color) {
        return (color & 0xFF0000) >>> 16;
    }

    public static int getGreen(int color) {
        return (color & 0xFF00) >>> 8;
    }

    public static int getBlue(int color) {
        return (color & 0xFF) >>> 0;
    }

    public static int getColor(int alpha, int red, int green, int blue) {
        alpha = Math.min(alpha, 255);
        red = Math.min(red, 255);
        green = Math.min(green, 255);
        blue = Math.min(blue, 255);
        return alpha << 24 | red << 16 | green << 8 | blue << 0;
    }

    public static int updateAlpha(int color, byte alpha) {
        return alpha << 24 | color & 0xFFFFFF;
    }
}

