/*
 * Decompiled with CFR 0.152.
 */
package ej.microvg.gradient;

import ej.microvg.MatrixHelper;
import ej.microvg.Util;
import ej.microvg.gradient.LLVGDynamicLinearGradientImpl;
import ej.microvg.paint.LinearGradient;
import ej.microvg.paint.VGPaint;
import java.awt.Color;

public class DynamicLinearGradientFull
implements LLVGDynamicLinearGradientImpl {
    private static final int GRADIENT_OFFSET_COLORS_SIZE = 0;
    private static final int GRADIENT_OFFSET_XSTART = 1;
    private static final int GRADIENT_OFFSET_YSTART = 2;
    private static final int GRADIENT_OFFSET_XEND = 3;
    private static final int GRADIENT_OFFSET_YEND = 4;
    private static final int GRADIENT_OFFSET_COLORS_OFFSET = 5;
    private static final int GRADIENT_OFFSET_POSITION_OFFSET = 6;
    private static final int GRADIENT_HEADER_SIZE = 7;

    @Override
    public int initializeGradient(int[] gradient, int length, int[] colors, int count, float[] positions, float xStart, float yStart, float xEnd, float yEnd) {
        int expectedLength;
        if (count < 2) {
            int color = count < 1 ? 0 : colors[0];
            colors = new int[]{color, color};
            positions = new float[]{0.0f, 1.0f};
            count = 2;
        }
        if (length < (expectedLength = this.getGradientHeaderSize() + count * 2)) {
            return expectedLength;
        }
        gradient[0] = count;
        gradient[1] = Float.floatToIntBits(xStart);
        gradient[2] = Float.floatToIntBits(yStart);
        gradient[3] = Float.floatToIntBits(xEnd);
        gradient[4] = Float.floatToIntBits(yEnd);
        gradient[5] = this.getGradientHeaderSize();
        gradient[6] = this.getGradientHeaderSize() + count;
        System.arraycopy(colors, 0, gradient, gradient[5], count);
        int headerOffset = gradient[6];
        int i = 0;
        while (i < count) {
            gradient[headerOffset + i] = Float.floatToIntBits(positions[i]);
            ++i;
        }
        return 0;
    }

    @Override
    public int getGradientHeaderSize() {
        return 7;
    }

    @Override
    public int getGradientNbColors(int[] gradient) {
        return gradient[0];
    }

    @Override
    public int getGradientColorsOffset(int[] gradient) {
        return gradient[5];
    }

    @Override
    public int getGradientPositionsOffset(int[] gradient) {
        return gradient[6];
    }

    @Override
    public VGPaint createGradient(int[] gradient, float[] gradientMatrix, float[] globalMatrix, int globalAlpha) {
        try {
            int count = this.getGradientNbColors(gradient);
            int colorOffset = this.getGradientColorsOffset(gradient);
            int positionOffset = this.getGradientPositionsOffset(gradient);
            Color[] colors = Util.getColors(gradient, colorOffset, count, globalAlpha);
            float[] fractions = Util.getGradientFractions(gradient, positionOffset, count);
            float[] localMatrix = MatrixHelper.create();
            MatrixHelper.copy(localMatrix, globalMatrix);
            MatrixHelper.concatenate(localMatrix, gradientMatrix);
            return new LinearGradient(colors, fractions, localMatrix, Float.intBitsToFloat(gradient[1]), Float.intBitsToFloat(gradient[2]), Float.intBitsToFloat(gradient[3]), Float.intBitsToFloat(gradient[4]));
        }
        catch (Throwable throwable) {
            return null;
        }
    }
}

