/*
 * Decompiled with CFR 0.152.
 */
package ej.microvg.font;

import ej.microui.display.LLUIDisplay;
import ej.microui.display.MicroUIFont;
import ej.microui.display.MicroUIFontFormat;
import ej.microui.display.MicroUIGraphicsContext;
import ej.microui.display.UIFontDrawing;
import ej.microvg.FontHelper;
import ej.microvg.LLVGEngine;
import ej.microvg.MatrixHelper;
import ej.microvg.paint.VGColor;
import ej.microvg.paint.VGPaint;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class VectorUiFontDrawer
implements UIFontDrawing {
    private static final int INT_SIZE = 4;
    private static final int OPAQUE = 255;
    private static final int NO_RADIUS = 0;
    private static final int DEFAULT_DIRECTION = 0;

    public MicroUIFontFormat handledFormat() {
        return LLVGEngine.VECTOR_FONT_FORMAT;
    }

    public int stringWidth(char[] string, MicroUIFont font) {
        ByteBuffer fontDataBuffer = this.mapBuffer(font);
        int face = this.getFace(fontDataBuffer);
        int size = this.getSize(fontDataBuffer);
        return (int)FontHelper.stringWidth(string, face, size, 0.0f);
    }

    public void draw(MicroUIGraphicsContext gc, char[] string, MicroUIFont font, int x, int y) {
        ByteBuffer fontDataBuffer = this.mapBuffer(font);
        int face = this.getFace(fontDataBuffer);
        int size = this.getSize(fontDataBuffer);
        VGColor gcColor = new VGColor(VGPaint.applyOpacity(gc.getMicroUIColor(), 255));
        float[] matrix = MatrixHelper.createIdentity();
        LLVGEngine.Instance.getVGDrawer(gc).drawString(gc, string, face, size, x, y, matrix, 1, gcColor, 0.0f, 0.0f, 0);
    }

    public void drawScaledStringBilinear(MicroUIGraphicsContext gc, char[] string, MicroUIFont font, int x, int y, float xRatio, float yRatio) {
        ByteBuffer fontDataBuffer = this.mapBuffer(font);
        int face = this.getFace(fontDataBuffer);
        int size = this.getSize(fontDataBuffer);
        VGColor gcColor = new VGColor(VGPaint.applyOpacity(gc.getMicroUIColor(), 255));
        float[] matrix = MatrixHelper.createIdentity();
        MatrixHelper.scale(matrix, xRatio, yRatio);
        LLVGEngine.Instance.getVGDrawer(gc).drawString(gc, string, face, size, x, y, matrix, 1, gcColor, 0.0f, 0.0f, 0);
    }

    public void drawCharWithRotationBilinear(MicroUIGraphicsContext gc, char c, MicroUIFont font, int destX, int destY, int xRotation, int yRotation, float angle, int alpha) {
        ByteBuffer fontDataBuffer = this.mapBuffer(font);
        int face = this.getFace(fontDataBuffer);
        int size = this.getSize(fontDataBuffer);
        VGColor gcColor = new VGColor(VGPaint.applyOpacity(gc.getMicroUIColor(), alpha));
        float[] matrix = MatrixHelper.createIdentity();
        int relativeRotationX = xRotation - destX;
        int relativeRotationY = yRotation - destY;
        MatrixHelper.translate(matrix, relativeRotationX, relativeRotationY);
        MatrixHelper.rotate(matrix, angle);
        MatrixHelper.translate(matrix, -relativeRotationX, -relativeRotationY);
        LLVGEngine.Instance.getVGDrawer(gc).drawString(gc, new char[]{c}, face, size, destX, destY, matrix, 1, gcColor, 0.0f, 0.0f, 0);
    }

    public void drawCharWithRotationNearestNeighbor(MicroUIGraphicsContext gc, char c, MicroUIFont font, int destX, int destY, int xRotation, int yRotation, float angle, int alpha) {
        this.drawCharWithRotationBilinear(gc, c, font, destX, destY, xRotation, yRotation, angle, alpha);
    }

    private ByteBuffer mapBuffer(MicroUIFont font) {
        byte[] fontData = font.getFontData();
        ByteBuffer fontDataBuffer = ByteBuffer.wrap(fontData);
        ByteOrder endianness = LLUIDisplay.Instance.getEndianness();
        fontDataBuffer.order(endianness);
        return fontDataBuffer;
    }

    private int getFace(ByteBuffer buffer) {
        return buffer.getInt();
    }

    private int getSize(ByteBuffer buffer) {
        return buffer.getInt(4);
    }
}

