/*
 * Decompiled with CFR 0.152.
 */
package ej.microvg;

import com.is2t.hil.HIL;
import ej.fp.FrontPanel;
import ej.microui.display.LLUIDisplay;
import ej.microui.display.MicroUIGraphicsContext;
import ej.microui.display.MicroUIImage;
import ej.microvg.MicroVGImage;
import ej.microvg.Util;
import ej.microvg.bvi.BufferedVectorImageDrawer;
import ej.microvg.display.DisplayDrawer;
import ej.microvg.gradient.DynamicLinearGradientFull;
import ej.microvg.gradient.DynamicLinearGradientOneColor;
import ej.microvg.gradient.LLVGDynamicLinearGradientImpl;
import ej.microvg.image.ColorMatrixVisitor;
import ej.microvg.image.ImageDecoder;
import ej.microvg.image.RawImageHolder;
import ej.microvg.image.StubImageDecoder;
import ej.microvg.image.bvi.BufferedVectorImage;
import ej.microvg.image.raw.RawImage;
import ej.microvg.path.DynamicPath;
import ej.microvg.path.DynamicPathStub;
import ej.microvg.path.LLVGDynamicPathImpl;
import java.util.HashMap;

public class VectorGraphicsNatives {
    public static final int PATH_INVALID = -1;
    public static final int DATA_INVALID = -2;
    public static final int SNICONTEXT_SIZE = 4;
    private static int nextId = 0;
    private static HashMap<Integer, RawImageHolder> compileTimeImages;
    private static HashMap<Integer, MicroVGImage> runtimeTimeImages;
    private static int javaVersion;
    private static ImageDecoder imageDecoder;
    private static DisplayDrawer displayDrawer;
    private static BufferedVectorImageDrawer bufferedVectorImageDrawer;
    private static LLVGDynamicPathImpl dynamicPathEngine;
    private static LLVGDynamicLinearGradientImpl dynamicLinearGradientEngine;

    private VectorGraphicsNatives() {
    }

    public static void initialize() {
        javaVersion = VectorGraphicsNatives.retrieveJavaVersion();
        compileTimeImages = new HashMap(10);
        runtimeTimeImages = new HashMap(10);
        VectorGraphicsNatives.checkVersion();
    }

    private static void checkVersion() {
        String userVersion = System.getProperty("frontpanel.vg-frontpanel.user.version");
        String internalVersion = System.getProperty("frontpanel.vg-frontpanel.intern.version");
        if (userVersion != null) {
            try {
                FrontPanel.getFrontPanel().checkVersion(internalVersion, userVersion);
            }
            catch (Exception e) {
                throw new RuntimeException("Front Panel runtime error: the Front Panel project has fetched the library \"com.microej.pack.vg#vg-pack(vg-frontpanel)\" whose version is not compatible with the VG Pack used to build the VEE Port; ensure to use same VG Pack version between the VEE Port and Front Panel project.", e);
            }
        }
    }

    public static int getJavaVersion() {
        return javaVersion;
    }

    private static int retrieveJavaVersion() {
        String version = System.getProperty("java.version");
        if (version.startsWith("1.")) {
            version = version.substring(2, 3);
        } else {
            int dot = version.indexOf(46);
            if (dot != -1) {
                version = version.substring(0, dot);
            }
        }
        return Integer.parseInt(version);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getImage(byte[] path, int pathLength, byte[] sniContext, int[] metadata) {
        int ret;
        HIL.getInstance().refreshContent((Object)path, 0, pathLength);
        String fullPath = new String(path, 0, pathLength);
        RawImageHolder image = VectorGraphicsNatives.getRawImage(fullPath);
        if (image != null) {
            Object object = VectorGraphicsNatives.getMonitor();
            synchronized (object) {
                image.duplicate(sniContext, metadata);
            }
            ret = 0;
        } else {
            byte[] data = HIL.getInstance().getResourceContent(fullPath);
            if (data != null) {
                Object object = VectorGraphicsNatives.getMonitor();
                synchronized (object) {
                    image = VectorGraphicsNatives.createRawImageHolder(fullPath, data, sniContext, metadata);
                }
                ret = image != null ? 0 : -2;
            } else {
                ret = -1;
            }
        }
        if (ret == 0) {
            HIL.getInstance().flushContent((Object)sniContext);
            HIL.getInstance().flushContent((Object)metadata);
        }
        return ret;
    }

    private static Object getMonitor() {
        return LLUIDisplay.Instance;
    }

    private static RawImageHolder getRawImage(String path) {
        for (RawImageHolder rawImage : compileTimeImages.values()) {
            if (!rawImage.isSameResource(path)) continue;
            return rawImage;
        }
        return null;
    }

    private static RawImageHolder createRawImageHolder(String fullPath, byte[] data, byte[] sniContext, int[] metadata) {
        RawImageHolder holder = null;
        RawImage image = RawImage.createRawImage(data, metadata);
        if (image != null) {
            Integer uniqueID = VectorGraphicsNatives.getNewUniqueID(sniContext);
            holder = new RawImageHolder(fullPath, sniContext, metadata, image);
            compileTimeImages.put(uniqueID, holder);
        }
        return holder;
    }

    private static Integer getNewUniqueID(byte[] sniContext) {
        int uniqueID = nextId++;
        Util.append(sniContext, 0, uniqueID);
        return uniqueID;
    }

    private static Integer getUniqueID(byte[] sniContext) {
        return Util.getInt(sniContext, 0);
    }

    public static MicroVGImage getVectorImage(byte[] sniContext) {
        Integer id = VectorGraphicsNatives.getUniqueID(sniContext);
        RawImageHolder holder = compileTimeImages.get(id);
        return holder != null ? holder.getRAWImage() : runtimeTimeImages.get(id);
    }

    public static ImageDecoder getImageDecoder() {
        if (imageDecoder == null) {
            imageDecoder = (ImageDecoder)Util.getImplementation(ImageDecoder.class, new StubImageDecoder());
        }
        return imageDecoder;
    }

    public static DisplayDrawer getDisplayDrawer() {
        if (displayDrawer == null) {
            displayDrawer = (DisplayDrawer)Util.getImplementation(DisplayDrawer.class, new DisplayDrawer());
        }
        return displayDrawer;
    }

    public static BufferedVectorImageDrawer getBufferedVectorImageDrawer() {
        if (bufferedVectorImageDrawer == null) {
            bufferedVectorImageDrawer = (BufferedVectorImageDrawer)Util.getImplementation(BufferedVectorImageDrawer.class, new BufferedVectorImageDrawer());
        }
        return bufferedVectorImageDrawer;
    }

    public static LLVGDynamicPathImpl getDynamicPathEngine() {
        if (dynamicPathEngine == null) {
            dynamicPathEngine = Util.isFeatureEnabled("dynamicPath") ? new DynamicPath() : new DynamicPathStub();
        }
        return dynamicPathEngine;
    }

    public static LLVGDynamicLinearGradientImpl getDynamicLinearGradientEngine() {
        if (dynamicLinearGradientEngine == null) {
            dynamicLinearGradientEngine = Util.isFeatureEnabled("dynamicLinearGradient") ? new DynamicLinearGradientFull() : new DynamicLinearGradientOneColor();
        }
        return dynamicLinearGradientEngine;
    }

    public static int createImage(byte[] sniContextSource, byte[] sniContextDest, float[] colorMatrix) {
        HIL.getInstance().refreshContent((Object)sniContextSource);
        HIL.getInstance().refreshContent((Object)colorMatrix);
        MicroVGImage source = VectorGraphicsNatives.getVectorImage(sniContextSource);
        MicroVGImage dest = source.transform(new ColorMatrixVisitor(colorMatrix));
        runtimeTimeImages.put(VectorGraphicsNatives.getNewUniqueID(sniContextDest), dest);
        HIL.getInstance().flushContent((Object)sniContextDest);
        return 0;
    }

    public static void closeImage(byte[] sniContext) {
        if (sniContext != null) {
            HIL.getInstance().refreshContent((Object)sniContext);
            runtimeTimeImages.remove(VectorGraphicsNatives.getUniqueID(sniContext));
        }
    }

    public static int loadImage(byte[] path, int pathLength, byte[] sniContext, int[] metadata) {
        return VectorGraphicsNatives.getImage(path, pathLength, sniContext, metadata);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void mapContext(byte[] uiContext, byte[] vgContext) {
        LLUIDisplay graphicsEngine;
        LLUIDisplay lLUIDisplay = graphicsEngine = LLUIDisplay.Instance;
        synchronized (lLUIDisplay) {
            MicroUIImage image = graphicsEngine.mapMicroUIImage(uiContext);
            BufferedVectorImage bvi = (BufferedVectorImage)image.getImage().getRAWImage();
            runtimeTimeImages.put(VectorGraphicsNatives.getNewUniqueID(vgContext), bvi);
            HIL.getInstance().flushContent((Object)vgContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clear(byte[] target) {
        LLUIDisplay graphicsEngine;
        LLUIDisplay lLUIDisplay = graphicsEngine = LLUIDisplay.Instance;
        synchronized (lLUIDisplay) {
            MicroUIGraphicsContext gc = graphicsEngine.mapMicroUIGraphicsContext(target);
            if (gc.requestDrawing()) {
                ((BufferedVectorImage)gc.getImage().getRAWImage()).clear();
            }
        }
    }
}

