/*
 * Decompiled with CFR 0.152.
 */
package ej.microvg;

import com.is2t.hil.HIL;
import ej.microvg.FontHelper;
import ej.microvg.FontHolder;
import ej.microvg.LLVGPainter;
import java.awt.Font;
import java.io.ByteArrayInputStream;

public class VectorFontNatives {
    private VectorFontNatives() {
    }

    public static final int loadFont(byte[] fontPath, boolean complexLayout) {
        if (complexLayout && !VectorFontNatives.hasComplexLayouter()) {
            return 0;
        }
        LLVGPainter.refreshContent(fontPath, 0, fontPath.length);
        try {
            String fontPathString = new String(fontPath, 0, fontPath.length - 1);
            byte[] resourceData = HIL.getInstance().getResourceContent(fontPathString);
            Font font = Font.createFont(0, new ByteArrayInputStream(resourceData));
            return FontHelper.add(new FontHolder(font, complexLayout));
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public static final float stringWidth(char[] string, int face, float size, float letterSpacing) {
        if (FontHelper.isClosed(face)) {
            return -6.0f;
        }
        LLVGPainter.refreshContent(string, 0, string.length);
        return FontHelper.stringWidth(string, face, size, letterSpacing);
    }

    public static final float stringHeight(char[] string, int face, float size) {
        if (FontHelper.isClosed(face)) {
            return -6.0f;
        }
        LLVGPainter.refreshContent(string, 0, string.length);
        return FontHelper.stringHeight(string, face, size);
    }

    public static final float getBaselinePosition(int face, float size) {
        if (FontHelper.isClosed(face)) {
            return -6.0f;
        }
        return FontHelper.getBaselinePosition(face, size);
    }

    public static final float getHeight(int face, float size) {
        if (FontHelper.isClosed(face)) {
            return -6.0f;
        }
        return FontHelper.getHeight(face, size);
    }

    public static void dispose(int face) {
        FontHelper.remove(face);
    }

    public static boolean hasComplexLayouter() {
        return true;
    }
}

