/*
 * Decompiled with CFR 0.152.
 */
package ej.microvg;

import ej.microui.display.LLUIDisplay;
import ej.microui.display.MicroUIGraphicsContext;
import ej.microui.display.MicroUIImageFormat;
import ej.microvg.BlendComposite;
import ej.microvg.FontHelper;
import ej.microvg.LLVGEngine;
import ej.microvg.LLVGPainter;
import ej.microvg.MatrixHelper;
import ej.microvg.MicroVGImage;
import ej.microvg.Util;
import ej.microvg.VGDrawing;
import ej.microvg.VectorFontNatives;
import ej.microvg.VectorGraphicsNatives;
import ej.microvg.bvi.BufferedVectorImageDrawer;
import ej.microvg.display.DisplayDrawer;
import ej.microvg.gradient.LLVGDynamicLinearGradientImpl;
import ej.microvg.image.bvi.BufferedVectorImageDrawerFull;
import ej.microvg.paint.VGPaint;
import ej.microvg.path.LLVGDynamicPathImpl;
import java.awt.Composite;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;

public class VGEngine
implements LLVGEngine {
    private static final int DIRECTION_CLOCKWISE = 0;
    private final Map<MicroUIImageFormat, VGDrawing> drawers = new HashMap<MicroUIImageFormat, VGDrawing>();
    private final VGDrawing stubDrawer = () -> null;
    private final BufferedVectorImageDrawer bufferedVectorImageDrawer = new BufferedVectorImageDrawerFull();
    private static Rectangle masterClip;

    @Override
    public void registerVGDrawer(VGDrawing drawer) {
        this.drawers.put(VGEngine.normalize(drawer.handledFormat()), drawer);
    }

    @Override
    public void unregisterVGDrawer(MicroUIImageFormat format) {
        this.drawers.remove(VGEngine.normalize(format));
    }

    @Override
    public VGDrawing getVGDrawer(MicroUIGraphicsContext gc) {
        MicroUIImageFormat gcFormat = gc.getFormat();
        return this.getVGDrawer(gcFormat);
    }

    @Override
    public VGDrawing getVGDrawer(MicroUIImageFormat format) {
        VGDrawing drawer = this.getRegisteredVGDrawer(format);
        if (drawer != null) {
            return drawer;
        }
        if (VGEngine.normalize(format) == MicroUIImageFormat.MICROUI_IMAGE_FORMAT_DISPLAY) {
            DisplayDrawer displayDrawer = VectorGraphicsNatives.getDisplayDrawer();
            this.drawers.put(MicroUIImageFormat.MICROUI_IMAGE_FORMAT_DISPLAY, displayDrawer);
            return displayDrawer;
        }
        return this.stubDrawer;
    }

    private VGDrawing getRegisteredVGDrawer(MicroUIImageFormat format) {
        return this.drawers.get(VGEngine.normalize(format));
    }

    private static MicroUIImageFormat normalize(MicroUIImageFormat format) {
        if (LLUIDisplay.Instance.isDisplayFormat(format)) {
            return MicroUIImageFormat.MICROUI_IMAGE_FORMAT_DISPLAY;
        }
        return format;
    }

    @Override
    public GeneralPath mapPath(byte[] path) {
        LLVGDynamicPathImpl engine = VectorGraphicsNatives.getDynamicPathEngine();
        LLVGPainter.refreshContent(path, 0, engine.getPathHeaderSize());
        int size = engine.getPathDataSize(path);
        int offset = engine.getPathDataOffset(path);
        LLVGPainter.refreshContent(path, offset, size);
        return engine.createGeneralPath(path);
    }

    @Override
    public VGPaint mapGradient(int[] gradientData, float[] gradientMatrix, float[] globalMatrix, int globalAlpha) {
        LLVGDynamicLinearGradientImpl engine = VectorGraphicsNatives.getDynamicLinearGradientEngine();
        LLVGPainter.refreshContent(gradientData, 0, engine.getGradientHeaderSize());
        int count = engine.getGradientNbColors(gradientData);
        LLVGPainter.refreshContent(gradientData, engine.getGradientColorsOffset(gradientData), count);
        LLVGPainter.refreshContent(gradientData, engine.getGradientPositionsOffset(gradientData), count);
        return VectorGraphicsNatives.getDynamicLinearGradientEngine().createGradient(gradientData, LLVGPainter.refreshMatrix(gradientMatrix), LLVGPainter.refreshMatrix(globalMatrix), globalAlpha);
    }

    @Override
    public MicroVGImage mapVectorImage(byte[] sniContext) {
        if (sniContext != null) {
            LLVGPainter.refreshContent(sniContext);
            return VectorGraphicsNatives.getVectorImage(sniContext);
        }
        return null;
    }

    public static void setMasterClip(Rectangle clip) {
        masterClip = clip;
    }

    public static void disableMasterClip() {
        masterClip = null;
    }

    @Override
    public void setClip(Graphics2D g2d, MicroUIGraphicsContext gc, GeneralPath path, AffineTransform at) {
        Util.setClip(g2d, gc, path, at);
        if (masterClip != null) {
            g2d.clipRect(VGEngine.masterClip.x, VGEngine.masterClip.y, VGEngine.masterClip.width, VGEngine.masterClip.height);
        }
    }

    @Override
    public int getFillRule(int fillRule) {
        switch (fillRule) {
            case 1: {
                return 0;
            }
        }
        return 1;
    }

    @Override
    public Composite getComposite(int blend) {
        switch (blend) {
            case 0: {
                return BlendComposite.SRC;
            }
            case 1: {
                return BlendComposite.SRC_OVER;
            }
            case 2: {
                return BlendComposite.DST_OVER;
            }
            case 3: {
                return BlendComposite.SRC_IN;
            }
            case 4: {
                return BlendComposite.DST_IN;
            }
            case 5: {
                return BlendComposite.DST_OUT;
            }
            case 6: {
                return BlendComposite.PLUS;
            }
            case 7: {
                return BlendComposite.SCREEN;
            }
            case 8: {
                return BlendComposite.MULTIPLY;
            }
        }
        throw new IllegalArgumentException("Unsupported blend mode: " + blend);
    }

    @Override
    public int drawString(MicroUIGraphicsContext gc, char[] string, int face, float size, float x, float y, float[] matrix, int blendMode, VGPaint p, float letterSpacing, float radius, int direction) {
        if (FontHelper.isClosed(face)) {
            return -6;
        }
        if (FontHelper.hasComplexLayout(face)) {
            this.complexLayoutDrawString(gc, string, face, size, x, y, matrix, blendMode, p, letterSpacing, radius, direction);
        } else {
            this.simpleLayoutDrawString(gc, string, face, size, x, y, matrix, blendMode, p, letterSpacing, radius, direction);
        }
        return 0;
    }

    private void simpleLayoutDrawString(MicroUIGraphicsContext gc, char[] string, int face, float size, float x, float y, float[] matrix, int blendMode, VGPaint p, float letterSpacing, float radius, int direction) {
        float advanceX = 0.0f;
        int length = string.length;
        int offset = 0;
        boolean firstGlyph = true;
        while (offset < length) {
            int charSize = FontHelper.getNextUtfSize(string, length, offset);
            String s = new String(string, offset, charSize);
            offset += charSize;
            float charWidth = FontHelper.getAdvanceX(s.toCharArray(), face, size);
            if (firstGlyph) {
                firstGlyph = false;
                advanceX = 0.0f == FontHelper.getGlyphWidth(s, face, size) ? (advanceX -= charWidth) : (advanceX -= FontHelper.getBearingX(s, face, size));
            }
            this.drawGlyph(gc, this.getCharacterGeneralPath(gc, s, face, size, 0), advanceX, charWidth, face, size, x, y, matrix, blendMode, p, radius, direction);
            float kerning = 0.0f;
            if (offset < length) {
                int nextCharSize = FontHelper.getNextUtfSize(string, length, offset);
                String nextChar = new String(string, offset, nextCharSize);
                kerning = FontHelper.getKerning(String.valueOf(s) + nextChar, face, size);
            }
            advanceX += charWidth + kerning + letterSpacing;
        }
    }

    private void complexLayoutDrawString(MicroUIGraphicsContext gc, char[] string, int face, float size, float x, float y, float[] matrix, int blendMode, VGPaint p, float letterSpacing, float radius, int direction) {
        Shape shape = FontHelper.getStringShape(string, face, size);
        if (0.0f == radius) {
            this.drawGlyph(gc, new GeneralPath(shape), 0.0f, 0.0f, face, size, x, y, matrix, blendMode, p, radius, direction);
        } else {
            float advanceX = 0.0f;
            float charWidth = 1.0f;
            double i = shape.getBounds().getMinX();
            while (i < shape.getBounds().getMaxX()) {
                Area area = new Area(new Rectangle2D.Double(i, shape.getBounds2D().getMinY(), charWidth, shape.getBounds2D().getHeight()));
                area.intersect(new Area(shape));
                AffineTransform at = new AffineTransform();
                at.translate(-i, 0.0);
                area.transform(at);
                this.drawGlyph(gc, new GeneralPath(area), advanceX, charWidth, face, size, x, y, matrix, blendMode, p, radius, direction);
                advanceX += charWidth;
                i += (double)charWidth;
            }
        }
    }

    private void drawGlyph(MicroUIGraphicsContext gc, GeneralPath path, float advanceX, float charWidth, int face, float size, float x, float y, float[] matrix, int blendMode, VGPaint p, float radius, int direction) {
        float[] localMatrix = MatrixHelper.create();
        MatrixHelper.copy(localMatrix, matrix);
        if (0.0f == radius) {
            MatrixHelper.translate(localMatrix, advanceX, VectorFontNatives.getBaselinePosition(face, size));
        } else {
            float sign = direction != 0 ? -1 : 1;
            float angleDegrees = 90.0f + VGEngine.getAngle(advanceX, radius) + VGEngine.getAngle(charWidth / 2.0f, radius);
            MatrixHelper.rotate(localMatrix, sign * angleDegrees);
            MatrixHelper.translate(localMatrix, 0.0f, -sign * radius);
            MatrixHelper.translate(localMatrix, -charWidth / 2.0f, 0.0f);
        }
        Instance.getVGDrawer(gc).drawPath(gc, path, x, y, localMatrix, 0, blendMode, p);
    }

    private GeneralPath getCharacterGeneralPath(MicroUIGraphicsContext gc, String string, int face, float size, int glyphIndex) {
        BufferedImage bi = new BufferedImage(1, 1, 2);
        Graphics2D g2d = (Graphics2D)bi.getGraphics();
        Font font = FontHelper.get(face, size);
        g2d.setFont(font);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        GlyphVector glyphVector = font.createGlyphVector(g2d.getFontRenderContext(), string);
        Shape glyph = glyphVector.getGlyphOutline(glyphIndex);
        return new GeneralPath(glyph);
    }

    private static float getAngle(double advance, float radius) {
        return (float)Math.toDegrees(advance / (double)radius);
    }

    @Override
    public BufferedVectorImageDrawer getBufferedVectorImageDrawer() {
        return this.bufferedVectorImageDrawer;
    }
}

